/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

public class Machines {
    public static final String[] NAMES = new String[]{"furnace", "pulverizer", "sawmill", "smelter", "crucible", "transposer", "iceGen", "rockGen", "waterGen", "assembler", "charger"};
    public static final int[] LIGHT_VALUES = new int[]{14, 0, 0, 15, 15, 0, 0, 14, 0, 0, 7};
    public static int[] guiIds = new int[Types.values().length];
    public static SideConfig[] sideData = new SideConfig[Types.values().length];
    public static PowerConfig[] powerData = new PowerConfig[Types.values().length];

    static {
        int id = Types.FURNACE.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {1}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        powerData[id].setPowerParams(2);
        id = Types.PULVERIZER.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 5;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {1, 2}, {3}, {1, 2, 3}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false, false, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true, true, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 2, 3, 4};
        powerData[id].setPowerParams(4);
        id = Types.SAWMILL.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 5;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {1, 2}, {3}, {1, 2, 3}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false, false, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true, true, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 2, 3, 4};
        powerData[id].setPowerParams(2);
        id = Types.SMELTER.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 7;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0, 1}, {2, 3}, {4}, {2, 3, 4}, {0}, {1}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false, false, false, true, true};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true, true, true, false, false};
        Machines.sideData[id].sideTex = new int[]{0, 1, 2, 3, 4, 5, 6};
        powerData[id].setPowerParams(4);
        id = Types.CRUCIBLE.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, new int[0]};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, false};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        powerData[id].setPowerParams(4, 40, 40000);
        id = Types.TRANSPOSER.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 4;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {1}, new int[0]};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true, false};
        Machines.sideData[id].sideTex = new int[]{0, 1, 2, 3};
        powerData[id].setPowerParams(4);
        id = Types.ICE_GEN.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {0}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        powerData[id].setPowerParams(2);
        id = Types.ROCK_GEN.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {0}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        id = Types.WATER_GEN.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.sideData[id].numGroup = 2;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], new int[0]};
        Machines.sideData[id].allowInsertion = new boolean[]{false, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false};
        Machines.sideData[id].sideTex = new int[]{0, 4};
        id = Types.ASSEMBLER.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {1}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        powerData[id].setPowerParams(2);
        id = Types.CHARGER.ordinal();
        Machines.sideData[id] = new SideConfig();
        Machines.powerData[id] = new PowerConfig();
        Machines.sideData[id].numGroup = 3;
        Machines.sideData[id].slotGroups = new int[][]{new int[0], {0}, {1}};
        Machines.sideData[id].allowInsertion = new boolean[]{false, true, false};
        Machines.sideData[id].allowExtraction = new boolean[]{false, false, true};
        Machines.sideData[id].sideTex = new int[]{0, 1, 4};
        powerData[id].setPowerParams(1, 500, 40000);
    }

    public static enum Types {
        FURNACE,
        PULVERIZER,
        SAWMILL,
        SMELTER,
        CRUCIBLE,
        TRANSPOSER,
        ICE_GEN,
        ROCK_GEN,
        WATER_GEN,
        ASSEMBLER,
        CHARGER;

    }

    public static class PowerConfig {
        public int minPower;
        public int maxPower;
        public int maxEnergy;
        public float minPowerLevel;
        public float maxPowerLevel;
        public float energyRamp;

        public boolean setPowerParams(int minPower, int maxPower, int maxEnergy) {
            if (minPower <= 0 || maxPower <= 0 || maxEnergy <= 0) {
                return false;
            }
            this.minPower = minPower;
            this.maxPower = maxPower;
            this.maxEnergy = maxEnergy;
            this.maxPowerLevel = 8.0f * (float)maxEnergy / 10.0f;
            this.energyRamp = this.maxPowerLevel / (float)maxPower;
            this.minPowerLevel = (float)minPower * this.energyRamp;
            return true;
        }

        public boolean setPowerParams(int maxPower) {
            if (maxPower <= 0) {
                return false;
            }
            this.maxPower = maxPower;
            this.minPower = maxPower / 4;
            this.maxEnergy = this.maxPower * 1200;
            this.maxPowerLevel = 8.0f * (float)this.maxEnergy / 10.0f;
            this.energyRamp = this.maxPowerLevel / (float)maxPower;
            this.minPowerLevel = (float)this.minPower * this.energyRamp;
            return true;
        }
    }

    public static class SideConfig {
        public int numGroup;
        public int[][] slotGroups;
        public boolean[] allowInsertion;
        public boolean[] allowExtraction;
        public int[] sideTex;
    }
}

