/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.CoreUtils;
import cofh.util.ItemUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.item.SchematicHelper;

public class TileAssembler
extends TileMachinePower
implements ITankContainer {
    public static final int ID = Machines.Types.ASSEMBLER.ordinal();
    public static final int PROCESS_ENERGY = 2;
    public static final int MAX_LIQUID = 10000;
    LiquidTankAdv myTank = new LiquidTankAdv(10000);
    public boolean needsCraft = false;
    int outputTracker;

    public static void initialize() {
        Machines.guiIds[TileAssembler.ID] = ThermalExpansion.proxy.registerGui("Assembler", true);
        GameRegistry.registerTileEntity(TileAssembler.class, (String)"cofh.thermalexpansion.Assembler");
    }

    public TileAssembler() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[20];
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidTankAdv getTank() {
        return this.myTank;
    }

    public LiquidStack getTankLiquid() {
        return this.myTank.getLiquidNoCopy();
    }

    public int getScaledLiquid(int id, int scale) {
        if (this.myTank.getLiquidID() <= 0) {
            return 0;
        }
        if (id == this.myTank.getLiquidID()) {
            return this.myTank.getLiquidAmount() * scale / 10000;
        }
        return 0;
    }

    public boolean canCreate(ItemStack recipe) {
        return this.inventory[1] == null || recipe.func_77969_a(this.inventory[1]) && this.inventory[1].field_77994_a + recipe.field_77994_a <= recipe.func_77976_d();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateOutput() {
        if (this.inventory[0] == null) return;
        ItemStack recipeOutput = SchematicHelper.getOutput(this.inventory[0], this.field_70331_k);
        if (recipeOutput == null) {
            this.isActive = false;
            return;
        }
        int maxStack = MathHelper.minI((int)this.func_70297_j_(), (int)recipeOutput.func_77976_d());
        boolean startIndex = false;
        if (this.inventory[1] != null) {
            this.transferProducts();
        }
        if (this.canCreate(recipeOutput)) {
            if (this.createItem()) {
                if (this.inventory[1] == null) {
                    this.inventory[1] = recipeOutput.func_77946_l();
                } else {
                    this.inventory[1].field_77994_a += recipeOutput.field_77994_a;
                }
                this.isActive = true;
                return;
            }
            if (this.myProvider.getEnergyStored() >= 2.0f) {
                this.needsCraft = false;
            }
            this.wasActive = true;
            this.isActive = false;
            return;
        }
        if (this.isActive) {
            this.wasActive = true;
        }
        this.isActive = false;
    }

    public boolean createItem() {
        if (this.myProvider.getEnergyStored() < 2.0f) {
            return false;
        }
        ItemStack[] invClone = ItemUtils.cloneInv((ItemStack[])this.inventory);
        LiquidStack myLiquid = this.myTank.getLiquid();
        boolean found = false;
        for (int i = 0; i < 9; ++i) {
            LiquidStack gotStack;
            ItemStack recipeSlot = SchematicHelper.getSchematicSlot(this.inventory[0], i);
            if (myLiquid != null && (gotStack = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)recipeSlot)) != null && gotStack.isLiquidEqual(myLiquid) && myLiquid.amount >= gotStack.amount) {
                myLiquid.amount -= gotStack.amount;
                continue;
            }
            String recipeOre = SchematicHelper.getSchematicOreSlot(this.inventory[0], i);
            if (recipeSlot == null) continue;
            for (int a = 2; a < invClone.length; ++a) {
                if (invClone[a] == null || !ItemUtils.isItemEqualOre((ItemStack)invClone[a], (ItemStack)recipeSlot, (String)recipeOre)) continue;
                --invClone[a].field_77994_a;
                if (invClone[a].func_77973_b().func_77634_r()) {
                    ItemStack containerStack = invClone[a].func_77973_b().getContainerItemStack(invClone[a]);
                    if (containerStack.func_77984_f() && containerStack.func_77960_j() > containerStack.func_77958_k()) {
                        containerStack = null;
                    }
                    if (!(containerStack == null || invClone[a].func_77973_b().func_77630_h(invClone[a]) && ItemUtils.addItemStackToInventory((ItemStack[])invClone, (ItemStack)containerStack, (int)2))) {
                        if (invClone[a].field_77994_a <= 0) {
                            invClone[a] = containerStack;
                            if (containerStack.field_77994_a <= 0) {
                                invClone[a].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (invClone[a].field_77994_a <= 0) {
                    invClone[a] = null;
                }
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            found = false;
        }
        this.inventory = invClone;
        this.myTank.setLiquid(myLiquid);
        this.myProvider.subtractEnergy(2.0f);
        return true;
    }

    @Override
    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(1, 64, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.redstoneControlOrDisable()) {
            if (this.needsCraft) {
                this.updateOutput();
            } else if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                this.transferProducts();
            }
        } else {
            if (this.isActive) {
                this.wasActive = true;
            }
            this.isActive = false;
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.myTank.setLiquidID(j);
                return;
            }
            case 1: {
                this.myTank.setLiquidMeta(j);
                return;
            }
            case 2: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.myTank.getLiquid().itemID);
        iCrafting.func_71112_a(container, 1, this.myTank.getLiquid().itemMeta);
        iCrafting.func_71112_a(container, 2, this.myTank.getLiquid().amount);
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
        this.needsCraft = true;
        if (data.func_74764_b("tank")) {
            this.myTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("tank")));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
        if (this.myTank.getLiquidID() > 0) {
            data.func_74782_a("tank", (NBTBase)this.myTank.getLiquidNoCopy().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = super.func_70298_a(i, j);
        this.needsCraft = true;
        return result;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        this.needsCraft = true;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        this.needsCraft = true;
        return this.myTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        return this.myTank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.sideCache[direction.ordinal()] != 2) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.sideCache[direction.ordinal()] != 2) {
            return null;
        }
        return this.myTank;
    }
}

