/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.crafting.CrucibleManager;

public class TileCrucible
extends TileMachinePower
implements ITankContainer {
    public static final int ID = Machines.Types.CRUCIBLE.ordinal();
    static final int RATE = 100;
    public static final int MAX_LIQUID = 10000;
    LiquidTankAdv myTank = new LiquidTankAdv(10000);
    public LiquidStack renderLiquid = new LiquidStack(0, 0);
    int outputTrackerLiquid;

    public static void initialize() {
        Machines.guiIds[TileCrucible.ID] = ThermalExpansion.proxy.registerGui("Crucible", true);
        GameRegistry.registerTileEntityWithAlternatives(TileCrucible.class, (String)"cofh.thermalexpansion.Crucible", (String[])new String[]{"thermalexpansion.factory.Crucible"});
    }

    public TileCrucible() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[1];
        this.processInv = new ItemStack[1];
        this.myTank.setTankPressure(1);
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidStack getTankLiquid() {
        return this.myTank.getLiquidNoCopy();
    }

    public LiquidTankAdv getTank() {
        return this.myTank;
    }

    public int getScaledLiquid(int scale) {
        if (this.myTank.getLiquidID() <= 0) {
            return 0;
        }
        return this.myTank.getLiquidAmount() * scale / 10000;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        int energy = recipe.getEnergy();
        if (this.myProvider.getEnergyStored() < (float)energy) {
            return false;
        }
        if (this.myTank.getLiquidID() <= 0) {
            return true;
        }
        LiquidStack output = recipe.getOutput();
        return this.myTank.fill(output, false) == output.amount;
    }

    @Override
    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.processInv[0]);
        if (recipe == null) {
            this.processCur = 0.0f;
            this.isActive = false;
            return false;
        }
        LiquidStack output = recipe.getOutput();
        return this.myTank.fill(output, false) == output.amount;
    }

    @Override
    protected void processStart() {
        this.processInv[0] = this.inventory[0].func_77946_l();
        CrucibleManager.CrucibleRecipe recipe = CrucibleManager.getRecipe(this.processInv[0]);
        this.processEnd = recipe.getEnergy();
        this.renderLiquid = recipe.getOutput();
        this.inventory[0].field_77994_a -= recipe.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void processFinish() {
        LiquidStack output = CrucibleManager.getRecipe(this.processInv[0]).getOutput();
        this.processInv[0] = null;
        this.myTank.fill(output, true);
    }

    protected void transferLiquid() {
        if (this.myTank.getLiquidAmount() == 0) {
            return;
        }
        for (int i = this.outputTrackerLiquid + 1; i <= this.outputTrackerLiquid + 6; ++i) {
            int[] coords;
            TileEntity tile;
            int side = i % 6;
            if (this.sideCache[side] != 2 || !((tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof ITankContainer)) continue;
            int fillQty = MathHelper.minI((int)this.myTank.getLiquidAmount(), (int)100);
            int quantity = ((ITankContainer)tile).fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), new LiquidStack(this.myTank.getLiquidID(), fillQty, this.myTank.getLiquidMeta()), true);
            if (quantity <= 0) continue;
            this.myTank.drain(quantity, true);
            this.outputTrackerLiquid = side;
            break;
        }
    }

    @Override
    protected void transferProducts() {
    }

    @Override
    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.myTank.getLiquidID() > 0) {
            this.transferLiquid();
        }
        super.func_70316_g();
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.myTank.setLiquidID(j);
                return;
            }
            case 1: {
                this.myTank.setLiquidMeta(j);
                return;
            }
            case 2: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (this.myTank.getLiquidID() > 0 && this.myTank.getLiquidID() != this.renderLiquid.itemID) {
            this.renderLiquid = this.myTank.getLiquid().copy();
        }
        iCrafting.func_71112_a(container, 0, this.renderLiquid.itemID);
        iCrafting.func_71112_a(container, 1, this.renderLiquid.itemMeta);
        iCrafting.func_71112_a(container, 2, this.myTank.getLiquidAmount());
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTrackerLiquid = data.func_74762_e("output.liquid");
        if (data.func_74764_b("tank")) {
            this.myTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("tank")));
            this.renderLiquid = this.myTank.getLiquid();
        } else if (this.processInv[0] != null) {
            this.renderLiquid = CrucibleManager.getRecipe(this.processInv[0]).getOutput();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output.liquid", this.outputTrackerLiquid);
        if (this.myTank.getLiquidID() > 0) {
            data.func_74782_a("tank", (NBTBase)this.myTank.getLiquidNoCopy().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return side != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderUtils.getLiquidTexture((LiquidStack)this.renderLiquid) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getId()));
        }
        return side != this.facing ? IconRegistry.getIcon((String)BlockMachine.textureSelection, (int)Machines.sideData[this.getId()].sideTex[this.sideCache[side]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive_", (int)this.getId()) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getId()));
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        return this.myTank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.sideCache[direction.ordinal()] != 2) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.sideCache[direction.ordinal()] != 2) {
            return null;
        }
        return this.myTank;
    }
}

