/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.crafting.FurnaceManager;

public class TileFurnace
extends TileMachinePower {
    public static final int ID = Machines.Types.FURNACE.ordinal();
    public static final int DEFAULT_PROCESS_ENERGY = 160;
    int outputTracker;

    public static void initialize() {
        Machines.guiIds[TileFurnace.ID] = ThermalExpansion.proxy.registerGui("Furnace", true);
        GameRegistry.registerTileEntityWithAlternatives(TileFurnace.class, (String)"cofh.thermalexpansion.Furnace", (String[])new String[]{"thermalexpansion.factory.Furnace"});
    }

    public TileFurnace() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[2];
        this.processInv = new ItemStack[1];
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        int energy = FurnaceManager.getProcessEnergy(this.inventory[0]);
        if (energy == 0) {
            energy = 160;
        }
        if (this.myProvider.getEnergyStored() < (float)energy) {
            return false;
        }
        ItemStack output = FurnaceManager.getOutput(this.inventory[0]);
        if (output == null) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        int result = this.inventory[1].field_77994_a + output.field_77994_a;
        return result <= output.func_77976_d();
    }

    @Override
    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        ItemStack output = FurnaceManager.getOutput(this.processInv[0]);
        if (output == null) {
            this.processCur = 0.0f;
            this.isActive = false;
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        int result = this.inventory[1].field_77994_a + output.field_77994_a;
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    @Override
    protected void processStart() {
        this.processInv[0] = this.inventory[0].func_77946_l();
        this.processEnd = FurnaceManager.getProcessEnergy(this.inventory[0]);
        if (this.processEnd == 0.0f) {
            this.processEnd = 160.0f;
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void processFinish() {
        ItemStack output = FurnaceManager.getOutput(this.processInv[0]);
        if (this.inventory[1] == null) {
            this.inventory[1] = output;
        } else {
            this.inventory[1].field_77994_a += output.field_77994_a;
        }
    }

    @Override
    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(1, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
    }
}

