/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachineRoot;
import thermalexpansion.gui.element.IInfoPower;
import thermalexpansion.util.energy.PowerProviderAdv;

public abstract class TileMachinePower
extends TileMachineRoot
implements IPowerReceptor,
IInfoPower {
    PowerProviderAdv myProvider;
    Machines.PowerConfig config = Machines.powerData[this.getId()];
    private static int guiPacketId = PacketHandler.getAvailablePacketId();

    public TileMachinePower() {
        this.myProvider = new PowerProviderAdv();
        this.myProvider.configure(10 * this.config.maxPower, this.config.maxEnergy);
    }

    public Packet getGuiPacket() {
        Payload payload = new Payload(1, 0, 0, 3, 0);
        payload.boolPayload[0] = this.isActive;
        payload.floatPayload[0] = this.processCur;
        payload.floatPayload[1] = this.processEnd;
        payload.floatPayload[2] = this.myProvider.getEnergyStored();
        PacketTile packet = new PacketTile(guiPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    @Override
    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == guiPacketId) {
            this.isActive = packet.payload.boolPayload[0];
            this.processCur = packet.payload.floatPayload[0];
            this.processEnd = packet.payload.floatPayload[1];
            this.myProvider.setEnergyStored(packet.payload.floatPayload[2]);
        } else {
            super.handleTilePacket(packet);
        }
    }

    protected boolean canStart() {
        return false;
    }

    protected boolean canFinish() {
        return false;
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void transferProducts() {
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.processCur < this.processEnd) {
                float energy = this.getPower();
                this.myProvider.subtractEnergy(energy);
                this.processCur += energy;
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferProducts();
                this.myProvider.addEnergy(this.processCur % this.processEnd);
                this.myProvider.roundEnergyStored();
                this.processCur = 0.0f;
                if (this.canStart() && this.redstoneControlOrDisable()) {
                    this.processStart();
                    float energyToUse = this.getPower();
                    float energy = this.myProvider.useEnergy(0.0f, energyToUse, true);
                    this.processCur += energy;
                } else {
                    this.processCur = 0.0f;
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(this.field_70331_k);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                this.transferProducts();
            }
            if (this.canStart()) {
                this.processStart();
                float energyToUse = this.getPower();
                float energy = this.myProvider.useEnergy(0.0f, energyToUse, true);
                this.processCur += energy;
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
    }

    public int getScaledEnergyStored(int scale) {
        return MathHelper.round((double)(this.myProvider.getEnergyStored() * (float)scale / (float)this.myProvider.getMaxEnergyStored()));
    }

    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        float power = this.myProvider.getEnergyStored() / this.config.energyRamp;
        if (power < (float)this.config.minPower) {
            power = this.config.minPower;
        } else if (power > (float)this.config.maxPower) {
            power = this.config.maxPower;
        }
        return MathHelper.round((double)(power * (float)scale / (float)this.config.maxPower));
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && CoreUtils.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((EntityPlayer)((EntityPlayer)iCrafting), (Packet)this.getGuiPacket());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.myProvider.setEnergyStored(data.func_74760_g("energy.stored"));
            if (Float.isNaN(this.myProvider.getEnergyStored())) {
                this.myProvider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.myProvider.setEnergyStored(0.0f);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("energy.stored", this.myProvider.getEnergyStored());
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.myProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return this.myProvider.powerRequest();
    }

    @Override
    public float getPower() {
        if (!this.isActive) {
            return 0.0f;
        }
        if (this.myProvider.getEnergyStored() > this.config.maxPowerLevel) {
            return this.config.maxPower;
        }
        if (this.myProvider.getEnergyStored() < this.config.minPowerLevel) {
            return this.config.minPower;
        }
        int intPower = (int)(10.0f * this.myProvider.getEnergyStored() / this.config.energyRamp);
        return (float)intPower / 10.0f;
    }

    @Override
    public float getMaxPower() {
        return this.config.maxPower;
    }

    @Override
    public float getEnergy() {
        return this.myProvider.getEnergyStored();
    }

    @Override
    public float getMaxEnergy() {
        return this.config.maxEnergy;
    }
}

