/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import buildcraft.api.core.SafeTimeTracker;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.api.tileentity.ISidedBlockTexture;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.Machines;

public abstract class TileMachineRoot
extends TileInventory
implements ITilePacketHandler,
IReconfigurableFacing,
IReconfigurableSides,
ISidedBlockTexture,
ISidedInventory {
    byte facing;
    byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};
    ItemStack[] processInv = new ItemStack[0];
    public boolean isActive;
    public boolean wasActive;
    float processCur;
    float processEnd;
    SafeTimeTracker tracker = new SafeTimeTracker();
    private static int descPacketId = PacketHandler.getAvailablePacketId();

    public Packet func_70319_e() {
        Payload payload = new Payload(3, 7, 0, 0, 0);
        System.arraycopy(this.sideCache, 0, payload.bytePayload, 0, this.sideCache.length);
        payload.bytePayload[6] = this.facing;
        payload.boolPayload[0] = this.isActive;
        payload.boolPayload[1] = this.redstoneDisable;
        payload.boolPayload[2] = this.redstoneState;
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        System.arraycopy(packet.payload.bytePayload, 0, this.sideCache, 0, this.sideCache.length);
        this.facing = packet.payload.bytePayload[6];
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            this.isActive = packet.payload.boolPayload[0];
        }
        this.redstoneDisable = packet.payload.boolPayload[1];
        this.redstoneState = packet.payload.boolPayload[2];
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockMachine.field_71990_ca);
    }

    protected abstract void receiveGuiNetworkData(int var1, int var2);

    protected abstract void sendGuiNetworkData(Container var1, ICrafting var2);

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.sideCache = data.func_74770_j("side.array");
        if (this.sideCache.length == 0) {
            this.sideCache = new byte[]{0, 0, 0, 0, 0, 0};
        }
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumSides()) continue;
            this.sideCache[i] = 0;
        }
        this.facing = data.func_74771_c("side.facing");
        this.isActive = data.func_74767_n("flag.active");
        this.processCur = data.func_74760_g("process.cur");
        this.processEnd = data.func_74760_g("process.end");
        NBTTagList list = data.func_74761_m("process.inv");
        this.processInv = new ItemStack[this.processInv.length];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = (NBTTagCompound)list.func_74743_b(i);
            int slot = compound.func_74762_e("slot");
            if (slot < 0 || slot >= this.processInv.length) continue;
            this.processInv[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74773_a("side.array", this.sideCache);
        data.func_74774_a("side.facing", this.facing);
        data.func_74757_a("flag.active", this.isActive);
        data.func_74776_a("process.cur", this.processCur);
        data.func_74776_a("process.end", this.processEnd);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.processInv.length; ++i) {
            if (this.processInv[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("slot", i);
            this.processInv[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        data.func_74782_a("process.inv", (NBTBase)list);
    }

    public int getScaledProgress(int scale) {
        if (this.processEnd == 0.0f) {
            return 0;
        }
        return (int)(this.processCur * (float)scale / this.processEnd);
    }

    public abstract int getId();

    public boolean hasSide(int side) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] != side) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? Machines.LIGHT_VALUES[this.getId()] : 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, Machines.guiIds[this.getId()], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && this.isActive) {
            this.sendUpdatePacket(Side.CLIENT);
        } else if (this.tracker.markTimeIfDelay(this.field_70331_k, 200L) && this.wasActive) {
            this.wasActive = false;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    @Override
    public String func_70303_b() {
        return "machine." + Machines.NAMES[this.getId()];
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean rotateBlock() {
        if (this.isActive) {
            return false;
        }
        byte tempWest = this.sideCache[4];
        this.sideCache[4] = this.sideCache[3];
        this.sideCache[3] = this.sideCache[5];
        this.sideCache[5] = this.sideCache[2];
        this.sideCache[2] = tempWest;
        this.facing = (byte)BlockUtils.SIDE_LEFT[this.facing];
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        this.sideCache[side] = 0;
        this.sideCache[BlockUtils.SIDE_LEFT[side]] = 1;
        this.sideCache[BlockUtils.SIDE_OPPOSITE[side]] = 1;
        this.facing = (byte)side;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockMachine.field_71990_ca);
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(ForgeDirection side) {
        return this.setFacing(side.ordinal());
    }

    public boolean decrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + (this.getNumSides() - 1));
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumSides());
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean incrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumSides());
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean setSide(int side, int setting) {
        if (side == this.facing) {
            return false;
        }
        if (setting >= this.getNumSides()) {
            return false;
        }
        if (this.sideCache[side] == setting) {
            return false;
        }
        this.sideCache[side] = (byte)setting;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean resetSides() {
        boolean update = false;
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] <= 0) continue;
            this.sideCache[i] = 0;
            update = true;
        }
        if (update) {
            this.sendUpdatePacket(Side.SERVER);
        }
        return update;
    }

    public int getNumSides() {
        return Machines.sideData[this.getId()].numGroup;
    }

    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return side != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? IconRegistry.getIcon((String)"MachineActive_", (int)this.getId()) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getId()));
        }
        return IconRegistry.getIcon((String)BlockMachine.textureSelection, (int)Machines.sideData[this.getId()].sideTex[this.sideCache[side]]);
    }

    public int[] func_94128_d(int side) {
        return Machines.sideData[this.getId()].slotGroups[this.sideCache[side]];
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return Machines.sideData[this.getId()].allowInsertion[this.sideCache[side]];
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return Machines.sideData[this.getId()].allowExtraction[this.sideCache[side]];
    }
}

