/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachineRoot;

public class TileRockGen
extends TileMachineRoot
implements ITankContainer {
    public static final int ID = Machines.Types.ROCK_GEN.ordinal();
    static ItemStack[] processItems = new ItemStack[3];
    public static int[] processLava = new int[]{0, 0, 1000};
    public static int[] processWater = new int[]{0, 1000, 1000};
    public static int[] processTime = new int[]{40, 80, 120};
    public static final int MAX_LIQUID = 4000;
    LiquidTankAdv lavaTank = new LiquidTankAdv(LiquidRegistry.LAVA_ID, 0, 4000);
    LiquidTankAdv waterTank = new LiquidTankAdv(LiquidRegistry.WATER_ID, 0, 4000);
    byte curSelection;
    byte prevSelection;
    int outputTracker;
    private static int modePacketId;

    public static void initialize() {
        Machines.guiIds[TileRockGen.ID] = ThermalExpansion.proxy.registerGui("RockGen", true);
        GameRegistry.registerTileEntityWithAlternatives(TileRockGen.class, (String)"cofh.thermalexpansion.RockGen", (String[])new String[]{"thermalexpansion.factory.RockGen"});
    }

    public TileRockGen() {
        this.sideCache = new byte[]{2, 2, 1, 1, 1, 1};
        this.inventory = new ItemStack[4];
        this.inventory[1] = processItems[0];
        this.inventory[2] = processItems[1];
        this.inventory[3] = processItems[2];
        this.lavaTank.setLocked(true);
        this.waterTank.setLocked(true);
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidStack getTankLiquid(int tankIndex) {
        if (tankIndex == 0) {
            return this.lavaTank.getLiquidNoCopy();
        }
        return this.waterTank.getLiquidNoCopy();
    }

    public LiquidTankAdv getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.lavaTank;
        }
        return this.waterTank;
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public Packet getModePacket() {
        Payload payload = new Payload(0, 1, 0, 0, 0);
        payload.bytePayload[0] = this.curSelection;
        PacketTile packet = new PacketTile(modePacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void setCurSelection(int i) {
        this.curSelection = (byte)i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getModePacket());
        }
    }

    public int getScaledLiquid(int id, int scale) {
        if (id == LiquidRegistry.WATER_ID) {
            if (this.waterTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.waterTank.getLiquidAmount() * scale / 4000;
        }
        if (id == LiquidRegistry.LAVA_ID) {
            if (this.lavaTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.lavaTank.getLiquidAmount() * scale / 4000;
        }
        return 0;
    }

    @Override
    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == modePacketId) {
            this.curSelection = packet.payload.bytePayload[0];
            if (this.processCur == 0.0f) {
                this.prevSelection = this.curSelection;
            }
        } else {
            super.handleTilePacket(packet);
        }
    }

    public boolean canStart() {
        if (this.lavaTank.getLiquidAmount() < 1000 || this.waterTank.getLiquidAmount() < 1000) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(processItems[this.curSelection])) {
            return false;
        }
        int result = this.inventory[0].field_77994_a + TileRockGen.processItems[this.curSelection].field_77994_a;
        return result <= processItems[this.curSelection].func_77976_d();
    }

    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        return this.inventory[0].func_77973_b() == processItems[this.prevSelection].func_77973_b() && this.inventory[0].field_77994_a < this.inventory[0].func_77976_d();
    }

    protected void processStart() {
        this.processEnd = processTime[this.curSelection];
        this.lavaTank.adjustLiquid(-processLava[this.curSelection]);
        this.waterTank.adjustLiquid(-processWater[this.curSelection]);
        this.prevSelection = this.curSelection;
    }

    protected void processFinish() {
        if (this.inventory[0] == null) {
            this.inventory[0] = processItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].field_77994_a += TileRockGen.processItems[this.prevSelection].field_77994_a;
        }
        this.prevSelection = this.curSelection;
    }

    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(0, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.processCur < this.processEnd) {
                this.processCur += 1.0f;
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferProducts();
                this.processCur = 0.0f;
                if (this.redstoneControlOrDisable() && this.canStart()) {
                    this.processStart();
                } else {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(this.field_70331_k);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                this.transferProducts();
            }
            if (this.canStart()) {
                this.processStart();
                this.processCur += 1.0f;
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                if (j == 1) {
                    this.isActive = true;
                    return;
                }
                this.isActive = false;
                return;
            }
            case 1: {
                this.processCur = j;
                return;
            }
            case 2: {
                this.curSelection = (byte)j;
                return;
            }
            case 3: {
                this.prevSelection = (byte)j;
                this.processEnd = processTime[this.prevSelection];
                return;
            }
            case 4: {
                this.lavaTank.setLiquidAmount(j);
                return;
            }
            case 5: {
                this.waterTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        int active = this.isActive ? 1 : 0;
        iCrafting.func_71112_a(container, 0, active);
        iCrafting.func_71112_a(container, 1, (int)this.processCur);
        iCrafting.func_71112_a(container, 2, (int)this.curSelection);
        iCrafting.func_71112_a(container, 3, (int)this.prevSelection);
        iCrafting.func_71112_a(container, 4, this.lavaTank.getLiquidAmount());
        iCrafting.func_71112_a(container, 5, this.waterTank.getLiquidAmount());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
        this.prevSelection = data.func_74771_c("selection.prev");
        this.curSelection = data.func_74771_c("selection.cur");
        this.lavaTank.setLiquidAmount(data.func_74762_e("qty.lava"));
        this.waterTank.setLiquidAmount(data.func_74762_e("qty.water"));
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
        data.func_74774_a("selection.prev", this.prevSelection);
        data.func_74774_a("selection.cur", this.curSelection);
        data.func_74768_a("qty.lava", this.lavaTank.getLiquidAmount());
        data.func_74768_a("qty.water", this.waterTank.getLiquidAmount());
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length - 3;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        if (resource.itemID == LiquidRegistry.LAVA_ID) {
            return this.lavaTank.fill(resource, doFill);
        }
        if (resource.itemID == LiquidRegistry.WATER_ID) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.lavaTank, this.waterTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return null;
        }
        if (type == null) {
            return null;
        }
        if (type.itemID == LiquidRegistry.LAVA_ID) {
            return this.lavaTank;
        }
        if (type.itemID == LiquidRegistry.WATER_ID) {
            return this.waterTank;
        }
        return null;
    }

    static {
        TileRockGen.processItems[0] = new ItemStack(Block.field_71978_w);
        TileRockGen.processItems[1] = new ItemStack(Block.field_71981_t);
        TileRockGen.processItems[2] = new ItemStack(Block.field_72089_ap);
        int[] tweakRockGenLava = new int[3];
        int[] tweakRockGenWater = new int[3];
        int[] tweakRockGenTime = new int[3];
        tweakRockGenLava[0] = ThermalExpansion.config.get("tweak", "RockGen.Cobblestone.Lava", processLava[0]);
        tweakRockGenLava[1] = ThermalExpansion.config.get("tweak", "RockGen.Stone.Lava", processLava[1]);
        tweakRockGenLava[2] = ThermalExpansion.config.get("tweak", "RockGen.Obsidian.Lava", processLava[2]);
        tweakRockGenWater[0] = ThermalExpansion.config.get("tweak", "RockGen.Cobblestone.Water", processWater[0]);
        tweakRockGenWater[1] = ThermalExpansion.config.get("tweak", "RockGen.Stone.Water", processWater[1]);
        tweakRockGenWater[2] = ThermalExpansion.config.get("tweak", "RockGen.Obsidian.Water", processWater[2]);
        tweakRockGenTime[0] = ThermalExpansion.config.get("tweak", "RockGen.Cobblestone.Time", processTime[0]);
        tweakRockGenTime[1] = ThermalExpansion.config.get("tweak", "RockGen.Stone.Time", processTime[1]);
        tweakRockGenTime[2] = ThermalExpansion.config.get("tweak", "RockGen.Obsidian.Time", processTime[2]);
        for (int i = 0; i < 3; ++i) {
            if (tweakRockGenLava[i] >= 0 && tweakRockGenLava[i] <= 4000) {
                TileRockGen.processLava[i] = tweakRockGenLava[i];
            }
            if (tweakRockGenWater[i] >= 0 && tweakRockGenWater[i] <= 4000) {
                TileRockGen.processWater[i] = tweakRockGenWater[i];
            }
            if (tweakRockGenTime[i] < 20 || tweakRockGenTime[i] > 72000) continue;
            TileRockGen.processTime[i] = tweakRockGenTime[i];
        }
        modePacketId = PacketHandler.getAvailablePacketId();
    }
}

