/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.plate;

import buildcraft.api.tools.IToolWrench;
import cofh.api.core.IInitializer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.render.IconRegistry;
import cofh.util.CoreUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.plate.TilePlateImpulse;
import thermalexpansion.block.plate.TilePlateRoot;
import thermalexpansion.block.plate.TilePlateTranslocate;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.Utils;

public class BlockPlate
extends BlockTERoot
implements IInitializer {
    public static final String[] NAMES = new String[]{"impulse", "transport"};
    public static boolean enable;
    public static ItemStack impulsePlate;

    public BlockPlate(int id) {
        super(id, Material.field_76243_f);
        this.func_71905_a(-0.01f, -0.01f, -0.01f, 1.01f, 0.0635f, 1.01f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.plate");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            return new TilePlateImpulse();
        }
        if (metadata == 1) {
            return new TilePlateTranslocate();
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (CoreUtils.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        if (CoreUtils.isClientWorld((World)world)) {
            return true;
        }
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof IReconfigurableFacing && Utils.isHoldingUsableWrench(player, x, y, z)) {
            ((IReconfigurableFacing)theTile).rotateBlock();
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack theItem) {
        IReconfigurableFacing theTile = (IReconfigurableFacing)world.func_72796_p(x, y, z);
        if (theTile != null) {
            int quadrant = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (quadrant) {
                case 0: {
                    theTile.setFacing(3);
                    return;
                }
                case 1: {
                    theTile.setFacing(4);
                    return;
                }
                case 2: {
                    theTile.setFacing(2);
                    return;
                }
                case 3: {
                    theTile.setFacing(5);
                    return;
                }
            }
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity theEntity) {
        TilePlateRoot theTile = (TilePlateRoot)world.func_72796_p(x, y, z);
        if (theTile == null) {
            return;
        }
        theTile.onEntityCollidedWithBlock(theEntity);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + 0.0625, (double)(z + 1));
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP);
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return this.func_71854_d(world, x, y, z);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71878_a(world, x, y, z, vec3d, vec3d1);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        float maxY = 0.0625f;
        TilePlateRoot theTile = (TilePlateRoot)world.func_72796_p(x, y, z);
        if (theTile != null && theTile.mode < 2) {
            maxY = 0.125f;
        }
        this.func_71905_a(-0.01f, -0.01f, -0.01f, 1.01f, maxY, 1.01f);
    }

    public int func_71857_b() {
        return TEProps.renderIdPlate;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"PlateBottom", (String)"thermalexpansion:Plate_Bottom", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop0", (String)"thermalexpansion:Plate_Top_Down", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop1", (String)"thermalexpansion:Plate_Top_Up", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop2", (String)"thermalexpansion:Plate_Top_North", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop3", (String)"thermalexpansion:Plate_Top_South", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop4", (String)"thermalexpansion:Plate_Top_West", (IconRegister)ir);
        IconRegistry.addIcon((String)"PlateTop5", (String)"thermalexpansion:Plate_Top_East", (IconRegister)ir);
    }

    public void initialize() {
        TilePlateImpulse.initialize();
        TilePlateTranslocate.initialize();
        impulsePlate = new ItemStack(TEBlocks.blockPlate, 1, 0);
        ItemRegistry.registerItem("plateImpulse", impulsePlate);
    }

    public void loadRecipes() {
    }

    static {
        String string = "block.feature";
    }

    public static enum Types {
        REDSTONE,
        GLOWSTONE,
        ENDER;

    }
}

