/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tesseract;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.Configuration;
import thermalexpansion.block.tesseract.TileTesseractEnergy;
import thermalexpansion.block.tesseract.TileTesseractItem;
import thermalexpansion.block.tesseract.TileTesseractLiquid;

public class TesseractRegistry {
    public static Map energyInputs = new HashMap();
    public static Map liquidInputs = new HashMap();
    public static Map itemInputs = new HashMap();
    public static Map energyOutputs = new HashMap();
    public static Map liquidOutputs = new HashMap();
    public static Map itemOutputs = new HashMap();
    public static Configuration linkConf;
    public static Map clientFrequencyNames;
    public static Map clientFrequencyNamesReversed;

    public static void clear() {
        energyInputs.clear();
        liquidInputs.clear();
        itemInputs.clear();
        energyOutputs.clear();
        liquidOutputs.clear();
        itemOutputs.clear();
    }

    public static List getLinkedInputs(TileTesseractItem theTile) {
        if (itemInputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static List getLinkedInputs(TileTesseractLiquid theTile) {
        if (liquidInputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static List getLinkedInputs(TileTesseractEnergy theTile) {
        if (energyInputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static List getLinkedOutputs(TileTesseractItem theTile) {
        if (itemOutputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static List getLinkedOutputs(TileTesseractLiquid theTile) {
        if (liquidOutputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static List getLinkedOutputs(TileTesseractEnergy theTile) {
        if (energyOutputs.get(theTile.getOwner()) == null) {
            return null;
        }
        return (List)((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency);
    }

    public static void add(TileTesseractItem theTile) {
        if (theTile.canSend()) {
            if (itemInputs.get(theTile.getOwner()) == null) {
                itemInputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)itemInputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
        if (theTile.canReceive()) {
            if (itemOutputs.get(theTile.getOwner()) == null) {
                itemOutputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)itemOutputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
    }

    public static void add(TileTesseractLiquid theTile) {
        if (theTile.canSend()) {
            if (liquidInputs.get(theTile.getOwner()) == null) {
                liquidInputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)liquidInputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
        if (theTile.canReceive()) {
            if (liquidOutputs.get(theTile.getOwner()) == null) {
                liquidOutputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)liquidOutputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
    }

    public static void add(TileTesseractEnergy theTile) {
        if (theTile.canSend()) {
            if (energyInputs.get(theTile.getOwner()) == null) {
                energyInputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)energyInputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
        if (theTile.canReceive()) {
            if (energyOutputs.get(theTile.getOwner()) == null) {
                energyOutputs.put(theTile.getOwner(), new HashMap());
            }
            if (((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency) == null) {
                ((Map)energyOutputs.get(theTile.getOwner())).put(theTile.frequency, new LinkedList());
            }
            if (!((List)((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency)).contains(theTile)) {
                ((List)((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency)).add(theTile);
            }
        }
    }

    public static void remove(TileTesseractItem theTile) {
        if (itemInputs.get(theTile.getOwner()) != null && ((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)itemInputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)itemInputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
        if (itemOutputs.get(theTile.getOwner()) != null && ((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)itemOutputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)itemOutputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
    }

    public static void remove(TileTesseractLiquid theTile) {
        if (liquidInputs.get(theTile.getOwner()) != null && ((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)liquidInputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)liquidInputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
        if (liquidOutputs.get(theTile.getOwner()) != null && ((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)liquidOutputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)liquidOutputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
    }

    public static void remove(TileTesseractEnergy theTile) {
        if (energyInputs.get(theTile.getOwner()) != null && ((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)energyInputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)energyInputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
        if (energyOutputs.get(theTile.getOwner()) != null && ((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency) != null) {
            ((List)((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency)).remove(theTile);
            if (((List)((Map)energyOutputs.get(theTile.getOwner())).get(theTile.frequency)).size() == 0) {
                ((Map)energyOutputs.get(theTile.getOwner())).remove(theTile.frequency);
            }
        }
    }

    public static void sortClientNames() {
        LinkedList list = new LinkedList(clientFrequencyNames.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Map.Entry o1, Map.Entry o2) {
                int int2;
                int int1 = Integer.valueOf((String)clientFrequencyNamesReversed.get(o1.getValue()));
                return int1 > (int2 = Integer.valueOf((String)clientFrequencyNamesReversed.get(o2.getValue())).intValue()) ? 1 : (int1 == int2 ? 0 : -1);
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        clientFrequencyNames = result;
    }
}

