/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tesseract;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.tesseract.BlockTesseract;
import thermalexpansion.block.tesseract.TesseractRegistry;
import thermalexpansion.block.tesseract.TileTesseractRoot;
import thermalexpansion.util.Utils;
import thermalexpansion.util.energy.PowerProviderTesseract;

public class TileTesseractEnergy
extends TileTesseractRoot
implements IPowerReceptor {
    public PowerProviderTesseract myProvider = new PowerProviderTesseract();
    int tickEnergyLimit;

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileTesseractEnergy.class, (String)"cofh.thermalexpansion.TesseractEnergy", (String[])new String[]{"thermalexpansion.transport.TeleportEnergy"});
    }

    public TileTesseractEnergy() {
        super("energy");
        this.myProvider.configure(PowerProviderTesseract.energyMax, PowerProviderTesseract.energyMax);
    }

    @Override
    public List getValidInputs() {
        List theTeleports = TesseractRegistry.getLinkedInputs(this);
        LinkedList<TileTesseractEnergy> validInputs = new LinkedList<TileTesseractEnergy>();
        if (theTeleports == null || !this.redstoneControlOrDisable()) {
            return validInputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            TileTesseractEnergy curTile = (TileTesseractEnergy)theTeleports.get(i);
            if (curTile.equals(this) || !curTile.redstoneControlOrDisable()) continue;
            validInputs.add(curTile);
        }
        return validInputs;
    }

    @Override
    public List getValidOutputs() {
        List theTeleports = TesseractRegistry.getLinkedOutputs(this);
        LinkedList<TileTesseractEnergy> validOutputs = new LinkedList<TileTesseractEnergy>();
        if (theTeleports == null || !this.redstoneControlOrDisable()) {
            return validOutputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            TileTesseractEnergy curTile = (TileTesseractEnergy)theTeleports.get(i);
            if (curTile.equals(this) || !curTile.redstoneControlOrDisable()) continue;
            validOutputs.add(curTile);
        }
        return validOutputs;
    }

    @Override
    public void addToRegistry() {
        if (this.frequency == -1) {
            return;
        }
        TesseractRegistry.add(this);
    }

    @Override
    public void removeFromRegistry() {
        TesseractRegistry.remove(this);
    }

    @Override
    public void incrementOutputTrackerAdjacent() {
        int theSide;
        ++this.outputTrackerAdjacent;
        for (theSide = this.outputTrackerAdjacent; theSide < 6; ++theSide) {
            if (!Utils.isAdjacentPoweredTile(this, theSide)) continue;
            this.outputTrackerAdjacent = theSide;
            return;
        }
        for (theSide = 0; theSide < this.outputTrackerAdjacent && theSide < 6; ++theSide) {
            if (!Utils.isAdjacentPoweredTile(this, theSide)) continue;
            this.outputTrackerAdjacent = theSide;
            return;
        }
        this.outputTrackerAdjacent = 0;
    }

    public void sendEnergy() {
        int i;
        List validOutputs = this.getValidOutputs();
        for (i = this.outputTrackerRemote; i < validOutputs.size() && this.myProvider.getEnergyStored() > 0.0f; ++i) {
            this.myProvider.subtractEnergy(((TileTesseractEnergy)validOutputs.get(i)).receiveEnergy(this.myProvider.getEnergyStored()));
        }
        for (i = 0; i < validOutputs.size() && i < this.outputTrackerRemote && this.myProvider.getEnergyStored() > 0.0f; ++i) {
            this.myProvider.subtractEnergy(((TileTesseractEnergy)validOutputs.get(i)).receiveEnergy(this.myProvider.getEnergyStored()));
        }
        this.incrementOutputTrackerRemote(validOutputs.size() - 1);
    }

    public float receiveEnergy(float maxAdd) {
        int theSide;
        if (this.tickEnergyLimit <= 0) {
            return 0.0f;
        }
        if (maxAdd > (float)this.tickEnergyLimit) {
            maxAdd = this.tickEnergyLimit;
        }
        float energyUsed = 0.0f;
        float wasMax = maxAdd;
        for (theSide = this.outputTrackerAdjacent; theSide < 6 && maxAdd > 0.0f; maxAdd -= energyUsed, ++theSide) {
            energyUsed = this.addToAdjPowerProvider(this, theSide, maxAdd);
            this.tickEnergyLimit = (int)((float)this.tickEnergyLimit - energyUsed);
        }
        for (theSide = 0; theSide < this.outputTrackerAdjacent && maxAdd > 0.0f; maxAdd -= energyUsed, ++theSide) {
            energyUsed = this.addToAdjPowerProvider(this, theSide, maxAdd);
            this.tickEnergyLimit = (int)((float)this.tickEnergyLimit - energyUsed);
        }
        this.incrementOutputTrackerAdjacent();
        return wasMax - maxAdd;
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.canReceive()) {
            this.tickEnergyLimit = PowerProviderTesseract.energyMax;
        }
        if (this.redstoneControlOrDisable() && this.myProvider.getEnergyStored() > 0.0f) {
            this.sendEnergy();
        }
    }

    public float addToAdjPowerProvider(TileEntity tile, int from, float maxAdd) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity tilePipe = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (tilePipe instanceof TileTesseractEnergy) {
            return 0.0f;
        }
        return Utils.addToAdjPowerProvider(this, from, maxAdd);
    }

    @Override
    public int getId() {
        return BlockTesseract.Types.ENERGY.ordinal();
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.myProvider.setEnergyStored(data.func_74760_g("energy.stored"));
            if (Float.isNaN(this.myProvider.getEnergyStored())) {
                this.myProvider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.myProvider.setEnergyStored(0.0f);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("energy.stored", this.myProvider.getEnergyStored());
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (this.redstoneControlOrDisable()) {
            return this.myProvider;
        }
        return Utils.dummyProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.frequency == -1 || !this.redstoneControlOrDisable() || !this.canSend() || this.getValidOutputs().size() == 0) {
            return 0;
        }
        return this.myProvider.powerRequest();
    }
}

