/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.item.tool;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.conduit.TileConduitEnergy;
import thermalexpansion.block.conduit.TileConduitLiquid;
import thermalexpansion.block.conduit.item.TileConduitItemBase;
import thermalexpansion.item.ItemTERoot;
import thermalexpansion.util.Utils;

public class ItemMultimeter
extends ItemTERoot {
    public ItemMultimeter(int id) {
        super(id);
        this.func_77625_d(1);
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (CoreUtils.isClientWorld((World)world)) {
            return false;
        }
        TileEntity theTile = world.func_72796_p(x, y, z);
        if (theTile instanceof TileConduitEnergy) {
            TileConduitEnergy tileConduit = (TileConduitEnergy)theTile;
            if (tileConduit.isNode() && tileConduit.canTransfer()) {
                if (tileConduit.energySent != null) {
                    player.func_70006_a("Average Distribution (" + tileConduit.energySent.size() + " ticks): " + tileConduit.getAverageTransfer());
                    tileConduit.trackEnergy = false;
                    tileConduit.energySent = null;
                } else {
                    tileConduit.energySent = new LinkedList();
                    tileConduit.trackEnergy = true;
                    player.func_70006_a("Monitoring for 20 ticks...");
                }
            } else {
                IPowerProvider tilePP = tileConduit.getPowerProvider();
                float saturation = 100.0f * tilePP.getEnergyStored() / (float)tilePP.getMaxEnergyStored();
                player.func_70006_a("Network Saturation: " + String.format("%.1f", Float.valueOf(saturation)) + "%");
            }
            return true;
        }
        if (theTile instanceof TileConduitLiquid) {
            if (((TileConduitLiquid)theTile).myGrid.myTank.getLiquid() == null) {
                player.func_70006_a("Liquid: Empty");
                return true;
            }
            player.func_70006_a("Liquid: " + ((TileConduitLiquid)theTile).myGrid.myTank.getLiquid().asItemStack().func_82833_r());
            player.func_70006_a("Amount: " + ((TileConduitLiquid)theTile).myGrid.getLiquidAmount() + "/" + ((TileConduitLiquid)theTile).myGrid.myTank.getCapacity() + " mB");
            player.func_70006_a("Throughput: " + ((TileConduitLiquid)theTile).myGrid.getLiquidThroughput() + "mB/t");
            return true;
        }
        if (theTile instanceof TileConduitItemBase) {
            if (((TileConduitItemBase)theTile).myGrid == null) {
                player.func_70006_a("Null Grid.");
                return true;
            }
            player.func_70006_a("Conduits: " + ((TileConduitItemBase)theTile).myGrid.conduitList.size());
            player.func_70006_a("Mode: " + ((TileConduitItemBase)theTile).mode);
            return true;
        }
        if (Utils.isPoweredTile(theTile) && !Utils.isPoweredTileLoss(theTile)) {
            IPowerReceptor tilePowered = (IPowerReceptor)theTile;
            IPowerProvider tilePP = tilePowered.getPowerProvider();
            player.func_70006_a("Energy Requested: " + MathHelper.minF((float)tilePowered.powerRequest(ForgeDirection.UNKNOWN), (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored())));
            return true;
        }
        return false;
    }
}

