/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins;

import java.util.ArrayList;
import thermalexpansion.ThermalExpansion;

public class TEPlugins {
    public static ArrayList pluginList = new ArrayList();

    public static void configure() {
        ThermalExpansion.log.info("Loading Plugins...");
        for (int i = 0; i < pluginList.size(); ++i) {
            ((Plugin)pluginList.get(i)).configure();
        }
        ThermalExpansion.log.info("Finished Loading Plugins.");
    }

    public static void initialize() {
        for (int i = 0; i < pluginList.size(); ++i) {
            ((Plugin)pluginList.get(i)).initialize();
        }
    }

    public static void loadRecipes() {
        for (int i = 0; i < pluginList.size(); ++i) {
            ((Plugin)pluginList.get(i)).loadRecipes();
        }
    }

    public static void cleanup() {
        pluginList.clear();
    }

    public static boolean addPlugin(String pluginPath, String pluginName) {
        boolean enable = ThermalExpansion.config.get("plugins", pluginName, true);
        ThermalExpansion.config.save();
        if (enable) {
            pluginList.add(new Plugin(pluginPath));
            return true;
        }
        return false;
    }

    static {
        TEPlugins.addPlugin("buildcraft.BCPlugin", "BuildCraft");
        TEPlugins.addPlugin("cc.CCPlugin", "ComputerCraft");
        TEPlugins.addPlugin("forestry.ForestryPlugin", "Forestry");
        TEPlugins.addPlugin("ic2.IC2Plugin", "IndustrialCraft");
        TEPlugins.addPlugin("metallurgy.MetallurgyPlugin", "Metallurgy");
        TEPlugins.addPlugin("mfr.MFRPlugin", "MineFactoryReloaded");
    }

    static class Plugin {
        public Class pluginClass = null;
        public String pluginPath;

        public Plugin(String pluginPath) {
            this.pluginPath = "thermalexpansion.plugins." + pluginPath;
        }

        public void configure() {
            try {
                this.pluginClass = TEPlugins.class.getClassLoader().loadClass(this.pluginPath);
                this.pluginClass.getMethod("configure", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void initialize() {
            try {
                if (this.pluginClass != null) {
                    this.pluginClass.getMethod("initialize", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void loadRecipes() {
            try {
                if (this.pluginClass != null) {
                    this.pluginClass.getMethod("loadRecipes", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void registerRenderInformation() {
            try {
                if (this.pluginClass != null) {
                    this.pluginClass.getMethod("registerRenderInformation", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

