/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.buildcraft.pipes;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.plugins.buildcraft.BCPlugin;
import thermalexpansion.util.Utils;

public class PipeItemsInsertion
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsInsertion(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicStone(), itemID);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BCPlugin.pipeIconProvider;
    }

    public int getIconIndex(ForgeDirection direction) {
        return 0;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        ItemStack theStack = item.getItemStack();
        Iterator iIt = possibleOrientations.iterator();
        while (iIt.hasNext()) {
            ForgeDirection dir = (ForgeDirection)iIt.next();
            if (!Utils.isAdjacentInventory((int)pos.x, (int)pos.y, (int)pos.z, this.worldObj, dir.ordinal())) continue;
            theStack.field_77994_a = Utils.addToAdjInventory((int)pos.x, (int)pos.y, (int)pos.z, this.worldObj, dir.ordinal(), theStack);
            if (theStack == null || theStack.field_77994_a <= 0) {
                item.remove();
                ((PipeTransportItems)this.transport).scheduleRemoval(item);
                return new LinkedList();
            }
            iIt.remove();
        }
        item.setItemStack(theStack);
        return possibleOrientations;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(IPipedItem item) {
        if (item.getSpeed() > buildcraft.core.utils.Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - buildcraft.core.utils.Utils.pipeNormalSpeed / 2.0f);
        }
        if (item.getSpeed() < buildcraft.core.utils.Utils.pipeNormalSpeed) {
            item.setSpeed(buildcraft.core.utils.Utils.pipeNormalSpeed);
        }
    }
}

