/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.buildcraft.triggers;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipe;
import cofh.render.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import thermalexpansion.plugins.buildcraft.triggers.TriggerEnergy;
import thermalexpansion.plugins.buildcraft.triggers.TriggerRegistry;
import thermalexpansion.plugins.buildcraft.triggers.TriggerTE;

public class TriggerProviderEnergy
implements ITriggerProvider,
IIconProvider {
    public static TriggerProviderEnergy instance = new TriggerProviderEnergy();
    public static TriggerTE triggerEmptyEnergy = new TriggerEnergy(TriggerEnergy.State.Empty);
    public static TriggerTE triggerContainsEnergy = new TriggerEnergy(TriggerEnergy.State.Contains);
    public static TriggerTE triggerSpaceEnergy = new TriggerEnergy(TriggerEnergy.State.Space);
    public static TriggerTE triggerFullEnergy = new TriggerEnergy(TriggerEnergy.State.Full);

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(Block block, TileEntity tile) {
        LinkedList<TriggerTE> triggers = new LinkedList<TriggerTE>();
        if (tile instanceof IPowerReceptor && ((IPowerReceptor)tile).getPowerProvider() != null) {
            triggers.add(triggerEmptyEnergy);
            triggers.add(triggerContainsEnergy);
            triggers.add(triggerSpaceEnergy);
            triggers.add(triggerFullEnergy);
        }
        return triggers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int iconIndex) {
        return IconRegistry.getIcon((String)"TrigEnergy", (int)iconIndex);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        IconRegistry.addIcon((String)("TrigEnergy" + TriggerEnergy.State.Empty.ordinal()), (String)"thermalexpansion:triggers/Trigger_Energy_Empty", (IconRegister)iconRegister);
        IconRegistry.addIcon((String)("TrigEnergy" + TriggerEnergy.State.Contains.ordinal()), (String)"thermalexpansion:triggers/Trigger_Energy_Contains", (IconRegister)iconRegister);
        IconRegistry.addIcon((String)("TrigEnergy" + TriggerEnergy.State.Space.ordinal()), (String)"thermalexpansion:triggers/Trigger_Energy_Space", (IconRegister)iconRegister);
        IconRegistry.addIcon((String)("TrigEnergy" + TriggerEnergy.State.Full.ordinal()), (String)"thermalexpansion:triggers/Trigger_Energy_Full", (IconRegister)iconRegister);
    }

    static {
        TriggerRegistry.add(triggerEmptyEnergy, "NoEnergy");
        TriggerRegistry.add(triggerContainsEnergy, "ContainsEnergy");
        TriggerRegistry.add(triggerSpaceEnergy, "SpaceForEnergy");
        TriggerRegistry.add(triggerFullEnergy, "FullEnergy");
    }
}

