/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.cc;

import cofh.api.block.IDismantleable;
import cofh.entity.PlayerFalse;
import cofh.util.BlockUtils;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.item.TEItems;
import thermalexpansion.plugins.cc.CCPlugin;

public class TurtleWrench
implements ITurtleUpgrade {
    private static final float DAMAGE_MULTIPLIER = 1.0f;
    private int m_id;
    private String m_adjective;
    protected ItemStack m_item;
    protected boolean m_secret;

    public TurtleWrench(int id, String adjective) {
        this.m_id = id;
        this.m_adjective = adjective;
        this.m_item = TEItems.wrench.func_77946_l();
        this.m_secret = false;
    }

    private boolean attack(ITurtleAccess turtle, int dir) {
        boolean result = turtle.attackWithItemStack(this.m_item.func_77946_l(), dir, 1.0f);
        if (!result) {
            int meta;
            World worldObj = turtle.getWorld();
            Vec3 position = turtle.getPosition();
            int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
            int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
            int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
            if (newY < 0 || newY >= worldObj.func_72940_L()) {
                return false;
            }
            int block = worldObj.func_72798_a(newX, newY, newZ);
            if (!this.rotateBlock(worldObj, block, meta = worldObj.func_72805_g(newX, newY, newZ), newX, newY, newZ, dir) && block > 0) {
                PlayerFalse player = new PlayerFalse(worldObj);
                player.setItemInHand(this.m_item);
                result = Block.field_71973_m[block].func_71903_a(worldObj, newX, newY, newZ, (EntityPlayer)player, dir, 0.5f, 0.5f, 0.5f);
            }
        }
        return result;
    }

    private boolean dig(ITurtleAccess turtle, int dir) {
        World worldObj = turtle.getWorld();
        Vec3 position = turtle.getPosition();
        int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
        int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
        int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
        if (newY < 0 || newY >= worldObj.func_72940_L()) {
            return false;
        }
        int bid = worldObj.func_72798_a(newX, newY, newZ);
        Block theBlock = Block.field_71973_m[bid];
        if (theBlock instanceof IDismantleable) {
            PlayerFalse player = new PlayerFalse(worldObj);
            if (((IDismantleable)theBlock).canDismantle((EntityPlayer)player, worldObj, newX, newY, newZ)) {
                this.storeItem(turtle, ((IDismantleable)theBlock).dismantleBlock((EntityPlayer)player, worldObj, newX, newY, newZ, true));
            }
        } else if (CCPlugin.turtlesCanBreakBlocks) {
            if (!this.canBreakBlock(worldObj, newX, newY, newZ)) {
                return false;
            }
            if (this.canHarvestBlock(worldObj, newX, newY, newZ)) {
                ArrayList items = this.getBlockDropped(worldObj, newX, newY, newZ);
                for (ItemStack item : items) {
                    this.storeItem(turtle, item);
                }
            }
            int blockID = worldObj.func_72798_a(newX, newY, newZ);
            worldObj.func_72926_e(2001, newX, newY, newZ, blockID + worldObj.func_72798_a(newX, newY, newZ) * 4096);
            worldObj.func_94571_i(newX, newY, newZ);
        }
        return true;
    }

    protected boolean canBreakBlock(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        return bid != 0 && bid != Block.field_71986_z.field_71990_ca && !(block.func_71934_m(world, x, y, z) <= -1.0f);
    }

    protected boolean canHarvestBlock(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        return block.field_72018_cp.func_76229_l();
    }

    private ArrayList getBlockDropped(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        int metadata = world.func_72805_g(x, y, z);
        return block.getBlockDropped(world, x, y, z, metadata, 0);
    }

    public boolean rotateBlock(World worldObj, int block, int meta, int newX, int newY, int newZ, int dir) {
        if (BlockUtils.canRotate((int)block)) {
            worldObj.func_72921_c(newX, newY, newZ, BlockUtils.rotateVanillaBlock((World)worldObj, (int)block, (int)meta, (int)newX, (int)newY, (int)newZ), 1);
            return true;
        }
        return Block.field_71973_m[block].rotateBlock(worldObj, newX, newY, newZ, ForgeDirection.getOrientation((int)dir));
    }

    public void storeItem(ITurtleAccess turtle, ItemStack item) {
        if (item != null && !turtle.storeItemStack(item) && !turtle.dropItemStack(item, turtle.getFacingDir())) {
            turtle.dropItemStack(item, turtle.getFacingDir());
        }
    }

    public int getUpgradeID() {
        return this.m_id;
    }

    public String getAdjective() {
        return this.m_adjective;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.m_item;
    }

    public boolean isSecret() {
        return this.m_secret;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int dir) {
        switch (verb.ordinal()) {
            case 1: {
                return this.attack(turtle, dir);
            }
            case 2: {
                return this.dig(turtle, dir);
            }
        }
        return this.dig(turtle, dir);
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.m_item.func_77954_c();
    }
}

