/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.LightModel;
import cofh.codechicken.core.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cofh.util.liquid.LiquidRegistry;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.TileConduitEnergy;
import thermalexpansion.block.conduit.TileConduitLiquid;
import thermalexpansion.block.conduit.TileConduitRoot;
import thermalexpansion.block.conduit.item.TileConduitItemBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.liquid.TELiquids;

@SideOnly(value=Side.CLIENT)
public class RenderConduit
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static RenderConduit instance = new RenderConduit();
    static final byte[] INV_SIDES = new byte[]{1, 1, 0, 0, 0, 0};
    static Icon[] texture = new Icon[3];
    static CCModel[][] liquid_models = new CCModel[6][7];
    static CCModel base_model;
    static CCModel[][] side_models;

    public static void initialize() {
        RenderConduit.texture[0] = IconRegistry.getIcon((String)"ConduitEnergy");
        RenderConduit.texture[1] = IconRegistry.getIcon((String)"ConduitLiquid");
        RenderConduit.texture[2] = IconRegistry.getIcon((String)"ConduitLiquid");
    }

    private static void generateLiquidModels() {
        for (int i = 1; i < 7; ++i) {
            double d1 = 0.47 - 0.025 * (double)i;
            double d2 = 0.53 + 0.025 * (double)i;
            double d3 = 0.32 + 0.06 * (double)i;
            double c1 = 0.32;
            double c2 = 0.68;
            double[][] boxes = new double[][]{{d1, 0.0, d1, d2, c1, d2}, {d1, d3, d1, d2, 1.0, d2}, {c1, c1, 0.0, c2, d3, c1}, {c1, c1, c2, c2, d3, 1.0}, {0.0, c1, c1, c1, d3, c2}, {c2, c1, c1, 1.0, d3, c2}, {c1, c1, c1, c2, d3, c2}};
            for (int s = 0; s < 7; ++s) {
                RenderConduit.liquid_models[i - 1][s] = CCModel.quadModel((int)24).generateBlock(0, boxes[s][0], boxes[s][1], boxes[s][2], boxes[s][3], boxes[s][4], boxes[s][5]).computeNormals();
            }
        }
    }

    private static void generateModels() {
        base_model = CCModel.quadModel((int)24).generateBox(0, -3.0, -3.0, -3.0, 6.0, 6.0, 6.0, 0.0, 16.0, 64.0, 64.0, 16.0).computeNormals().computeLighting(LightModel.standardLightModel);
        RenderConduit.side_models[0][1] = CCModel.quadModel((int)24).generateBox(0, -3.0, 3.0, -3.0, 6.0, 5.0, 6.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals();
        RenderConduit.side_models[1][1] = CCModel.quadModel((int)24).generateBox(0, -3.0, 3.0, -3.0, 6.0, 5.0, 6.0, 32.0, 0.0, 64.0, 64.0, 16.0).computeNormals();
        RenderConduit.side_models[2][1] = CCModel.quadModel((int)24).generateBox(0, -3.0, 3.0, -3.0, 6.0, 1.0, 6.0, 32.0, 0.0, 64.0, 64.0, 16.0).computeNormals();
        RenderConduit.side_models[3][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 32.0, 16.0, 64.0, 64.0, 16.0).computeNormals();
        RenderConduit.side_models[4][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 0.0, 32.0, 64.0, 64.0, 16.0).computeNormals();
        RenderConduit.side_models[5][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 32.0, 32.0, 64.0, 64.0, 16.0).computeNormals();
        for (int i = 0; i < side_models.length; ++i) {
            CCModel.generateSidedModels((CCModel[])side_models[i], (int)1, (Vector3)new Vector3());
            for (int s = 0; s < 6; ++s) {
                side_models[i][s].computeLighting(LightModel.standardLightModel);
            }
        }
    }

    public void render(int metadata, byte[] connection, int mode, int renderMode, double x, double y, double z) {
        x += 0.5;
        y += 0.5;
        z += 0.5;
        for (int s = 0; s < 6; ++s) {
            if (connection[s] == 1) {
                side_models[renderMode][s].render(x, y, z, texture[metadata]);
                continue;
            }
            if (connection[s] != 2) continue;
            side_models[2][s].render(x, y, z, texture[metadata]);
            side_models[mode + 3][s].render(x, y, z, texture[metadata]);
        }
        base_model.render(x, y, z, texture[metadata]);
    }

    public void renderLiquid(boolean setColor, LiquidStack liquid, byte[] sides, int level, double x, double y, double z) {
        if (liquid == null || liquid.amount <= 0 || liquid.itemID <= 0 || level <= 0) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing((int)7);
        if (setColor) {
            RenderUtils.setLiquidRenderColor((LiquidStack)liquid);
        }
        RenderUtils.setLiquidTextureSheet((LiquidStack)liquid);
        Icon liquidTex = RenderUtils.getLiquidTexture((LiquidStack)liquid);
        if (LiquidRegistry.isLiquidCompressible((LiquidStack)liquid)) {
            int alpha = 24 * level;
            CCRenderState.setColour((int)(-240 + alpha));
            level = 6;
        }
        CCModel[] models = liquid_models[level - 1];
        for (int s = 0; s < 6; ++s) {
            if (sides[s] <= 0) continue;
            models[s].render(x, y, z, liquidTex);
        }
        models[6].render(x, y, z, liquidTex);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public void func_76894_a(TileEntity entity, double x, double y, double z, float f) {
        RenderUtils.preRender();
        TileConduitRoot theTile = (TileConduitRoot)entity;
        this.renderLiquid(true, theTile.getRenderLiquid(), theTile.sideCache, theTile.getRenderLiquidLevel(), x, y, z);
        CCRenderState.useNormals((boolean)false);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.render(metadata /= 4096, INV_SIDES, 0, 0, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        if (metadata == BlockConduit.Types.ENERGY.ordinal()) {
            this.renderLiquid(false, TELiquids.liquidRedstone, INV_SIDES, 6, -0.5, -0.501, -0.5);
        }
        CCRenderState.useNormals((boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity aTile = world.func_72796_p(x, y, z);
        if (!(aTile instanceof TileConduitRoot)) {
            return false;
        }
        TileConduitRoot theTile = (TileConduitRoot)aTile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        this.render(theTile.getRenderId(), theTile.sideCache, theTile.mode, 1, x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdConduit;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            offset = 0.0;
        }
        RenderUtils.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.render(0, INV_SIDES, 0, 0, offset, offset, offset);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderUtils.setItemTextureSheet();
    }

    static {
        side_models = new CCModel[6][6];
        TEProps.renderIdConduit = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileConduitEnergy.class, (TileEntitySpecialRenderer)instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileConduitLiquid.class, (TileEntitySpecialRenderer)instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileConduitItemBase.class, (TileEntitySpecialRenderer)instance);
        RenderConduit.generateLiquidModels();
        RenderConduit.generateModels();
    }
}

