/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ClientRegistry;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.engine.Engines;
import thermalexpansion.block.engine.TileEngineMagmatic;
import thermalexpansion.block.engine.TileEngineRoot;
import thermalexpansion.block.engine.TileEngineSteam;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IItemRenderer {
    public static RenderEngine instance = new RenderEngine();
    static String[] texture = new String[Engines.Types.values().length];
    static ModelBase model = new ModelBase(){};
    private static ModelRenderer base;
    static ModelRenderer piston;
    static ModelRenderer extension;
    static ModelRenderer[] trunk;
    static double[][] translate;

    public static void initialize() {
        RenderEngine.texture[Engines.Types.STEAM.ordinal()] = "/mods/thermalexpansion/textures/blocks/Engine_Steam.png";
        RenderEngine.texture[Engines.Types.MAGMATIC.ordinal()] = "/mods/thermalexpansion/textures/blocks/Engine_Magmatic.png";
    }

    public void render(int metadata, boolean active, float progress, int facing, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float step = (double)progress > 0.5 ? 8.0f - (progress - 0.5f) * 2.0f * 8.0f : progress * 16.0f;
        float translateFactor = step / 16.0f;
        RenderEngine.base.field_78795_f = RenderUtils.angleBaseYNeg[facing][0];
        RenderEngine.base.field_78796_g = RenderUtils.angleBaseYNeg[facing][1];
        RenderEngine.base.field_78808_h = RenderUtils.angleBaseYNeg[facing][2];
        RenderEngine.piston.field_78795_f = RenderUtils.angleBaseYNeg[facing][0];
        RenderEngine.piston.field_78796_g = RenderUtils.angleBaseYNeg[facing][1];
        RenderEngine.piston.field_78808_h = RenderUtils.angleBaseYNeg[facing][2];
        RenderEngine.extension.field_78795_f = RenderUtils.angleBaseYNeg[facing][0];
        RenderEngine.extension.field_78796_g = RenderUtils.angleBaseYNeg[facing][1];
        RenderEngine.extension.field_78808_h = RenderUtils.angleBaseYNeg[facing][2];
        RenderUtils.bindTexture((String)texture[metadata]);
        base.func_78785_a(0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(translate[facing][0] * (double)translateFactor), (double)(translate[facing][1] * (double)translateFactor), (double)(translate[facing][2] * (double)translateFactor));
        piston.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        if (active) {
            RenderEngine.trunk[1].field_78795_f = RenderUtils.angleBaseYNeg[facing][0];
            RenderEngine.trunk[1].field_78796_g = RenderUtils.angleBaseYNeg[facing][1];
            RenderEngine.trunk[1].field_78808_h = RenderUtils.angleBaseYNeg[facing][2];
            trunk[1].func_78785_a(0.0625f);
        } else {
            RenderEngine.trunk[0].field_78795_f = RenderUtils.angleBaseYNeg[facing][0];
            RenderEngine.trunk[0].field_78796_g = RenderUtils.angleBaseYNeg[facing][1];
            RenderEngine.trunk[0].field_78808_h = RenderUtils.angleBaseYNeg[facing][2];
            trunk[0].func_78785_a(0.0625f);
        }
        float extensionFactor = 0.125f;
        int i = 0;
        while ((float)i < step + 2.0f) {
            extension.func_78785_a(0.0625f);
            GL11.glTranslated((double)(translate[facing][0] * (double)extensionFactor), (double)(translate[facing][1] * (double)extensionFactor), (double)(translate[facing][2] * (double)extensionFactor));
            i += 2;
        }
        GL11.glPopMatrix();
    }

    public void func_76894_a(TileEntity entity, double x, double y, double z, float f) {
        TileEngineRoot theTile = (TileEngineRoot)entity;
        this.render(theTile.getId(), theTile.isActive, theTile.getCycleProgress(), theTile.getFacing(), x, y, z);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                instance.render(item.func_77960_j(), false, 0.25f, 1, -0.5, -0.5, -0.5);
                break;
            }
            case EQUIPPED: {
                instance.render(item.func_77960_j(), false, 0.25f, 1, 0.0, 0.0, 0.0);
                break;
            }
            case INVENTORY: {
                instance.render(item.func_77960_j(), false, 0.25f, 1, -0.5, -0.5, -0.5);
                break;
            }
        }
    }

    static {
        trunk = new ModelRenderer[2];
        translate = new double[6][3];
        RenderEngine.translate[0][1] = -1.0;
        RenderEngine.translate[1][1] = 1.0;
        RenderEngine.translate[2][2] = -1.0;
        RenderEngine.translate[3][2] = 1.0;
        RenderEngine.translate[4][0] = -1.0;
        RenderEngine.translate[5][0] = 1.0;
        base = new ModelRenderer(model, 0, 0);
        base.func_78787_b(128, 64);
        base.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        RenderEngine.base.field_78800_c = 8.0f;
        RenderEngine.base.field_78797_d = 8.0f;
        RenderEngine.base.field_78798_e = 8.0f;
        piston = new ModelRenderer(model, 64, 0);
        piston.func_78787_b(128, 64);
        piston.func_78789_a(-7.0f, -4.0f, -7.0f, 14, 4, 14);
        RenderEngine.piston.field_78800_c = 8.0f;
        RenderEngine.piston.field_78797_d = 8.0f;
        RenderEngine.piston.field_78798_e = 8.0f;
        extension = new ModelRenderer(model, 0, 20);
        extension.func_78787_b(128, 64);
        extension.func_78789_a(-5.0f, -4.5f, -5.0f, 10, 2, 10);
        RenderEngine.extension.field_78800_c = 8.0f;
        RenderEngine.extension.field_78797_d = 8.0f;
        RenderEngine.extension.field_78798_e = 8.0f;
        for (int i = 0; i < 2; ++i) {
            RenderEngine.trunk[i] = new ModelRenderer(model, 32 * i, 44);
            trunk[i].func_78787_b(128, 64);
            trunk[i].func_78789_a(-4.0f, -4.0f, -4.0f, 8, 12, 8);
            RenderEngine.trunk[i].field_78800_c = 8.0f;
            RenderEngine.trunk[i].field_78797_d = 8.0f;
            RenderEngine.trunk[i].field_78798_e = 8.0f;
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineSteam.class, (TileEntitySpecialRenderer)instance);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineMagmatic.class, (TileEntitySpecialRenderer)instance);
    }
}

