/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.liquid.LiquidRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.ICrucibleManager;
import thermalexpansion.api.crafting.ICrucibleRecipe;
import thermalexpansion.core.TEProps;
import thermalexpansion.liquid.TELiquids;

public class CrucibleManager
implements ICrucibleManager {
    private static CrucibleManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMap;
    private static List recipeList;

    public static ICrucibleManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static CrucibleRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return (CrucibleRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static boolean recipeExists(ItemStack input) {
        if (input == null) {
            return true;
        }
        CrucibleRecipe recipe = (CrucibleRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        return recipe != null;
    }

    public static void initialize() {
        int defaultCost;
        CraftingManagers.crucibleManager = new CrucibleManager();
        boolean recipeNetherrack = ThermalExpansion.config.get("tweak", "Crucible.Netherrack", true);
        boolean recipeBlazeRod = ThermalExpansion.config.get("tweak", "Crucible.BlazeRod", true);
        int tweakNetherrackMJ = ThermalExpansion.config.get("tweak", "Crucible.Netherrack.Energy", TEProps.lavaMJ * 6 / 10);
        int tweakBlazeRodMJ = ThermalExpansion.config.get("tweak", "Crucible.BlazeRod.Energy", TEProps.lavaMJ / 10);
        if (recipeNetherrack) {
            if (tweakNetherrackMJ >= TEProps.lavaMJ / 10 && tweakNetherrackMJ <= 36000) {
                CrucibleManager.getInstance().addRecipe(tweakNetherrackMJ, new ItemStack(Block.field_72012_bb), new LiquidStack(LiquidRegistry.LAVA_ID, 1000));
            } else {
                CrucibleManager.getInstance().addRecipe(TEProps.lavaMJ * 6 / 10, new ItemStack(Block.field_72012_bb), new LiquidStack(LiquidRegistry.LAVA_ID, 1000));
                ThermalExpansion.log.log(Level.INFO, "'Crucible.Netherrack.Energy' config value is out of acceptable range. Using default.");
            }
        }
        if (recipeBlazeRod) {
            if (tweakBlazeRodMJ >= TEProps.lavaMJ / 20 && tweakBlazeRodMJ <= 36000) {
                CrucibleManager.getInstance().addRecipe(tweakBlazeRodMJ, new ItemStack(Item.field_77731_bo), new LiquidStack(LiquidRegistry.LAVA_ID, 250));
            } else {
                CrucibleManager.getInstance().addRecipe(TEProps.lavaMJ / 10, new ItemStack(Item.field_77731_bo), new LiquidStack(LiquidRegistry.LAVA_ID, 250));
                ThermalExpansion.log.log(Level.INFO, "'Crucible.BlazeRod.Energy' config value is out of acceptable range. Using default.");
            }
        }
        if ((defaultCost = TEProps.lavaMJ * 6 / 5) > 36000) {
            defaultCost = 36000;
        }
        CrucibleManager.getInstance().addRecipe(defaultCost, new ItemStack(Block.field_71978_w), new LiquidStack(LiquidRegistry.LAVA_ID, 1000));
        CrucibleManager.getInstance().addRecipe(defaultCost, new ItemStack(Block.field_71981_t), new LiquidStack(LiquidRegistry.LAVA_ID, 1000));
        CrucibleManager.getInstance().addRecipe(defaultCost, new ItemStack(Block.field_72089_ap), new LiquidStack(LiquidRegistry.LAVA_ID, 1000));
        CrucibleManager.getInstance().addRecipe(80, new ItemStack(Item.field_77768_aD, 4), new LiquidStack(LiquidRegistry.WATER_ID, 500));
        CrucibleManager.getInstance().addRecipe(80, new ItemStack(Block.field_72039_aU), new LiquidStack(LiquidRegistry.WATER_ID, 500));
        CrucibleManager.getInstance().addRecipe(160, new ItemStack(Block.field_72036_aT), new LiquidStack(LiquidRegistry.WATER_ID, 1000));
        CrucibleManager.getInstance().addRecipe(800, new ItemStack(Item.field_77767_aC), new LiquidStack(TELiquids.blockRedstone.field_71990_ca, 100));
        CrucibleManager.getInstance().addRecipe(7200, new ItemStack(Block.field_94341_cq), new LiquidStack(TELiquids.blockRedstone.field_71990_ca, 900));
        CrucibleManager.getInstance().addRecipe(2000, new ItemStack(Item.field_77751_aT), new LiquidStack(TELiquids.blockGlowstone.field_71990_ca, 250));
        CrucibleManager.getInstance().addRecipe(8000, new ItemStack(Block.field_72014_bd), new LiquidStack(TELiquids.blockGlowstone.field_71990_ca, 1000));
        CrucibleManager.getInstance().addRecipe(2000, new ItemStack(Item.field_77730_bn), new LiquidStack(TELiquids.blockEnder.field_71990_ca, 250));
    }

    public static void loadRecipes() {
    }

    public static boolean addTERecipe(int energy, ItemStack input, LiquidStack output) {
        return instance.addInternalRecipe(energy, input, output);
    }

    private boolean addInternalRecipe(int energy, ItemStack input, LiquidStack output) {
        CrucibleRecipe recipe;
        if (input == null || output == null || output.amount <= 0 || energy <= 0) {
            return false;
        }
        if (CrucibleManager.recipeExists(input)) {
            recipe = CrucibleManager.getRecipe(input);
            recipeList.remove(recipe);
        }
        recipe = new CrucibleRecipe(input, output, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, LiquidStack output, boolean overwrite) {
        CrucibleRecipe recipe;
        if (input == null || output == null || output.amount <= 0 || energy <= 0) {
            return false;
        }
        if (CrucibleManager.recipeExists(input)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                recipe = CrucibleManager.getRecipe(input);
                recipeList.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Magma Crucible recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Magma Crucible recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        recipe = new CrucibleRecipe(input, output, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, LiquidStack output) {
        return this.addRecipe(energy, input, output, false);
    }

    @Override
    public ICrucibleRecipe[] getRecipeList() {
        return recipeList.toArray(new CrucibleRecipe[0]);
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Crucible.Override", false)) {
            CrucibleManager.allowOverwrite();
        } else {
            CrucibleManager.denyOverwrite();
        }
        instance = new CrucibleManager();
        recipeMap = new HashMap();
        recipeList = new ArrayList();
    }

    public class CrucibleRecipe
    implements ICrucibleRecipe {
        final ItemStack input;
        final LiquidStack output;
        final int energy;

        CrucibleRecipe(ItemStack input, LiquidStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public LiquidStack getOutput() {
            return this.output.copy();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

