/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.IFurnaceManager;
import thermalexpansion.api.crafting.IFurnaceRecipe;

public class FurnaceManager
implements IFurnaceManager {
    private static FurnaceManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMap;
    private static List recipeList;

    public static IFurnaceManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static ItemStack getOutput(ItemStack input) {
        if (input == null) {
            return null;
        }
        FurnaceRecipe recipe = (FurnaceRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (recipe == null) {
            ItemStack ret = FurnaceRecipes.func_77602_a().getSmeltingResult(input);
            if (ret == null) {
                return null;
            }
            return ret.func_77946_l();
        }
        ItemStack ret = null;
        if (recipe.input.field_77994_a <= input.field_77994_a) {
            ret = recipe.getOutput();
        }
        return ret;
    }

    public static int getProcessEnergy(ItemStack input) {
        if (input == null) {
            return 0;
        }
        FurnaceRecipe recipe = (FurnaceRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        if (recipe == null) {
            return 0;
        }
        int ret = 0;
        if (recipe.input.field_77994_a <= input.field_77994_a) {
            ret = recipe.getEnergy();
        }
        return ret;
    }

    public static void initialize() {
        CraftingManagers.furnaceManager = new FurnaceManager();
        FurnaceManager.getInstance().addRecipe(80, new ItemStack(Block.field_72038_aV), new ItemStack(Item.field_77756_aW, 1, 2), false);
        FurnaceManager.getInstance().addRecipe(40, new ItemStack(Item.field_77784_aq), new ItemStack(Item.field_77782_ar), false);
        FurnaceManager.getInstance().addRecipe(40, new ItemStack(Item.field_77754_aU), new ItemStack(Item.field_77753_aV), false);
        FurnaceManager.getInstance().addRecipe(40, new ItemStack(Item.field_77741_bi), new ItemStack(Item.field_77734_bj), false);
        FurnaceManager.getInstance().addRecipe(40, new ItemStack(Item.field_77735_bk), new ItemStack(Item.field_77736_bl), false);
        FurnaceManager.getInstance().addRecipe(40, new ItemStack(Item.field_82794_bL), new ItemStack(Item.field_82795_bM), false);
    }

    public static void loadRecipes() {
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack output) {
        return instance.addInternalRecipe(energy, input, output);
    }

    private boolean addInternalRecipe(int energy, ItemStack input, ItemStack output) {
        FurnaceRecipe recipe;
        if (input == null || output == null || energy <= 0) {
            return false;
        }
        if (recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j())) != null) {
            recipe = (FurnaceRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
            recipeList.remove(recipe);
        }
        recipe = new FurnaceRecipe(input, output, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack output, boolean overwrite) {
        FurnaceRecipe recipe;
        if (input == null || output == null || energy <= 0) {
            return false;
        }
        if (recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j())) != null) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                recipe = (FurnaceRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
                recipeList.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Powered Furnace recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Powered Furnace recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        recipe = new FurnaceRecipe(input, output, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack output) {
        return this.addRecipe(energy, input, output, false);
    }

    @Override
    public IFurnaceRecipe[] getRecipeList() {
        return recipeList.toArray(new FurnaceRecipe[0]);
    }

    public static Map getRecipeMap() {
        return recipeMap;
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Furnace.Override", false)) {
            FurnaceManager.allowOverwrite();
        } else {
            FurnaceManager.denyOverwrite();
        }
        instance = new FurnaceManager();
        recipeMap = new HashMap();
        recipeList = new ArrayList();
    }

    public class FurnaceRecipe
    implements IFurnaceRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        FurnaceRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

