/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cpw.mods.fml.common.Loader;
import ic2.api.item.Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.ISawmillManager;
import thermalexpansion.api.crafting.ISawmillRecipe;
import thermalexpansion.item.TEItems;

public class SawmillManager
implements ISawmillManager {
    private static SawmillManager instance;
    private static boolean initialized;
    private static boolean allowOverwrite;
    private static Map recipeMap;
    private static List recipeList;

    public static ISawmillManager getInstance() {
        return instance;
    }

    public static void allowOverwrite() {
        if (!initialized) {
            initialized = true;
            allowOverwrite = true;
        }
    }

    public static void denyOverwrite() {
        initialized = true;
        allowOverwrite = false;
    }

    public static SawmillRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return (SawmillRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
    }

    public static boolean recipeExists(ItemStack input) {
        if (input == null) {
            return true;
        }
        SawmillRecipe recipe = (SawmillRecipe)recipeMap.get(Arrays.asList(input.field_77993_c, input.func_77960_j()));
        return recipe != null;
    }

    public static void initialize() {
        CraftingManagers.sawmillManager = new SawmillManager();
        SawmillManager.getInstance().addRecipe(80, new ItemStack(Block.field_71951_J, 1, 0), new ItemStack(Block.field_71988_x, 6, 0), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(80, new ItemStack(Block.field_71951_J, 1, 1), new ItemStack(Block.field_71988_x, 6, 1), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(80, new ItemStack(Block.field_71951_J, 1, 2), new ItemStack(Block.field_71988_x, 6, 2), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(80, new ItemStack(Block.field_71951_J, 1, 3), new ItemStack(Block.field_71988_x, 6, 3), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_71960_R), new ItemStack(Block.field_71988_x, 8), new ItemStack(Item.field_77767_aC, 1), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Item.field_77776_ba), new ItemStack(Block.field_71988_x, 3), new ItemStack(Block.field_72101_ab, 3), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_72093_an), new ItemStack(Block.field_71988_x, 6), new ItemStack(Item.field_77760_aL, 3), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack((Block)Block.field_72077_au), new ItemStack(Block.field_71988_x, 8), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_72060_ay), new ItemStack(Block.field_71988_x, 4), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Item.field_77792_au), new ItemStack(Block.field_71988_x, 2), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Item.field_77790_av), new ItemStack(Block.field_71988_x, 6), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_72046_aM), new ItemStack(Block.field_71988_x, 2), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_72032_aY), new ItemStack(Block.field_71988_x, 8), new ItemStack(Item.field_77702_n, 1), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_72005_bk), new ItemStack(Block.field_71988_x, 3), false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Block.field_71993_bv), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(240, new ItemStack(Item.field_77769_aE), new ItemStack(Block.field_71988_x, 5), false);
        SawmillManager.getInstance().addRecipe(160, new ItemStack(Item.field_77715_r), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(160, new ItemStack(Item.field_77714_s), new ItemStack(Block.field_71988_x, 1), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(160, new ItemStack(Item.field_77713_t), new ItemStack(Block.field_71988_x, 3), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(160, new ItemStack(Item.field_77712_u), new ItemStack(Block.field_71988_x, 3), TEItems.sawdust, false);
        SawmillManager.getInstance().addRecipe(160, new ItemStack(Item.field_77678_N), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust, false);
    }

    public static void loadRecipes() {
        int logWoodId = OreDictionary.getOreID((String)"logWood");
        int plankWoodId = OreDictionary.getOreID((String)"plankWood");
        List allRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allRecipes) {
            ItemStack log;
            ItemStack planks;
            ShapelessRecipes shapeRecipe;
            if (OreDictionary.getOreID((ItemStack)irecipe.func_77571_b()) != plankWoodId || irecipe.func_77570_a() != 1) continue;
            if (irecipe instanceof ShapelessRecipes) {
                shapeRecipe = (ShapelessRecipes)irecipe;
                if (OreDictionary.getOreID((ItemStack)((ItemStack)shapeRecipe.field_77579_b.get(0))) != logWoodId) continue;
                planks = irecipe.func_77571_b().func_77946_l();
                planks.field_77994_a = 6;
                log = ((ItemStack)shapeRecipe.field_77579_b.get(0)).func_77946_l();
                log.field_77994_a = 1;
                SawmillManager.getInstance().addRecipe(80, log, planks, TEItems.sawdust, false);
                continue;
            }
            if (irecipe instanceof ShapedRecipes) {
                shapeRecipe = (ShapedRecipes)irecipe;
                if (OreDictionary.getOreID((ItemStack)shapeRecipe.field_77574_d[0]) != logWoodId) continue;
                planks = irecipe.func_77571_b().func_77946_l();
                planks.field_77994_a = 6;
                log = shapeRecipe.field_77574_d[0].func_77946_l();
                log.field_77994_a = 1;
                SawmillManager.getInstance().addRecipe(80, log, planks, TEItems.sawdust, false);
                continue;
            }
            if (irecipe instanceof ShapedOreRecipe) {
                shapeRecipe = (ShapedOreRecipe)irecipe;
                if (shapeRecipe.getInput()[0] == null || OreDictionary.getOreID((ItemStack)((ItemStack)shapeRecipe.getInput()[0])) != logWoodId) continue;
                planks = irecipe.func_77571_b().func_77946_l();
                planks.field_77994_a = 6;
                log = ((ItemStack)shapeRecipe.getInput()[0]).func_77946_l();
                log.field_77994_a = 1;
                SawmillManager.getInstance().addRecipe(80, log, planks, TEItems.sawdust, false);
                continue;
            }
            if (!(irecipe instanceof ShapelessOreRecipe) || (shapeRecipe = (ShapelessOreRecipe)irecipe).getInput().get(0) == null || OreDictionary.getOreID((ItemStack)((ItemStack)shapeRecipe.getInput().get(0))) != logWoodId) continue;
            planks = irecipe.func_77571_b().func_77946_l();
            planks.field_77994_a = 6;
            log = ((ItemStack)shapeRecipe.getInput().get(0)).func_77946_l();
            log.field_77994_a = 1;
            SawmillManager.getInstance().addRecipe(80, log, planks, TEItems.sawdust, false);
        }
        ItemStack resin = null;
        ArrayList registeredOres = OreDictionary.getOres((String)"woodRubber");
        if (Loader.isModLoaded((String)"IC2")) {
            try {
                resin = Items.getItem((String)"resin");
                if (resin == null) {
                    ThermalExpansion.log.log(Level.INFO, "Don't panic over the failed IC2 call. Either IC2 is not installed or the IC2 API has been changed.");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        for (int i = 0; i < registeredOres.size(); ++i) {
            if (resin != null) {
                SawmillManager.getInstance().addRecipe(120, (ItemStack)registeredOres.get(i), new ItemStack(Block.field_71988_x, 4, 3), resin, 33, false);
                continue;
            }
            SawmillManager.getInstance().addRecipe(120, (ItemStack)registeredOres.get(i), new ItemStack(Block.field_71988_x, 4, 3), false);
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return instance.addInternalRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance);
    }

    private boolean addInternalRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        SawmillRecipe recipe;
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        if (SawmillManager.recipeExists(input)) {
            recipe = SawmillManager.getRecipe(input);
            recipeList.remove(recipe);
        }
        recipe = new SawmillRecipe(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, boolean overwrite) {
        return this.addRecipe(energy, input, primaryOutput, null, 0, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, 100, overwrite);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        SawmillRecipe recipe;
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        if (SawmillManager.recipeExists(input)) {
            if (!overwrite) {
                return false;
            }
            if (allowOverwrite) {
                recipe = SawmillManager.getRecipe(input);
                recipeList.remove(recipe);
                ThermalExpansion.log.log(Level.INFO, "A Sawmill recipe is being overwritten - this has been enabled in your configuration file.");
            } else {
                ThermalExpansion.log.log(Level.WARNING, "A mod attempted to overwrite a Sawmill recipe. To allow this, enable the functionality in your configuration file.");
                return false;
            }
        }
        recipe = new SawmillRecipe(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(input.field_77993_c, input.func_77960_j()), recipe);
        recipeList.add(recipe);
        return true;
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return this.addRecipe(energy, input, primaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, false);
    }

    @Override
    public boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return this.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    @Override
    public ISawmillRecipe[] getRecipeList() {
        return recipeList.toArray(new SawmillRecipe[0]);
    }

    static {
        if (ThermalExpansion.config.get("tweak.craftinghandlers", "Sawmill.Override", false)) {
            SawmillManager.allowOverwrite();
        } else {
            SawmillManager.denyOverwrite();
        }
        instance = new SawmillManager();
        recipeMap = new HashMap();
        recipeList = new ArrayList();
    }

    public class SawmillRecipe
    implements ISawmillRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        SawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        @Override
        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

