/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;

    public void func_70312_q() {
        super.func_70312_q();
        IC2.addSingleTickCallback(this.field_70331_k, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                TileEntityBlock.this.onLoaded();
                if (TileEntityBlock.this.enableUpdateEntity()) {
                    world.field_73009_h.add(TileEntityBlock.this);
                }
            }
        });
    }

    public void func_70313_j() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_70313_j();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        if (!IC2.platform.isSimulating()) {
            IC2.network.requestInitialData(this);
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return false;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            IC2.network.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            IC2.network.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), 1, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public void onBlockBreak(int a, int b) {
    }
}

