/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerGeoGenerator;
import ic2.core.block.generator.gui.GuiGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ITankContainer {
    public int maxLava = 24000;
    public final InvSlotConsumableLiquid fuelSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "fuel", 1, 1, new LiquidStack(Block.field_71938_D, 1));

    public TileEntityGeoGenerator() {
        super(IC2.energyGeneratorGeo, Math.max(IC2.energyGeneratorGeo, 32));
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.fuel + 1000 > this.maxLava) {
            return false;
        }
        ItemStack liquid = this.fuelSlot.consume(1);
        if (liquid == null) {
            return false;
        }
        this.fuel += 1000;
        return true;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String func_70303_b() {
        if (IC2.platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGeoGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiGeoGenerator(new ContainerGeoGenerator(entityPlayer, this));
    }

    @Override
    public void onBlockBreak(int a, int b) {
        LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidSpilledEvent(new LiquidStack(Block.field_71938_D.field_71990_ca, this.fuel), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource.itemID != Block.field_71938_D.field_71990_ca) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, (this.maxLava - this.fuel) / 1);
        if (doFill) {
            this.fuel += toAdd / 1;
        }
        return toAdd;
    }

    public LiquidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(0, maxEmpty, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        return null;
    }

    public LiquidTank[] getTanks(ForgeDirection side) {
        LiquidTank tank = new LiquidTank(new LiquidStack(Block.field_71938_D.field_71990_ca, this.fuel * 1), this.maxLava * 1, (TileEntity)this);
        tank.setTankPressure(0);
        return new LiquidTank[]{tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return type != null && type.itemID == Block.field_71938_D.field_71990_ca ? this.getTanks(ForgeDirection.UNKNOWN)[0] : null;
    }
}

