/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerStandardMachine;
import ic2.core.block.machine.gui.GuiCompressor;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCompressor
extends TileEntityStandardMachine {
    public TileEntityPump validPump;
    public static List recipes = new Vector();

    public TileEntityCompressor() {
        super(2, 400);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.compressor);
    }

    public static void init() {
        Recipes.compressor = new BasicMachineRecipeManager();
        Recipes.compressor.addRecipe(Ic2Items.plantBall, Ic2Items.compressedPlantBall);
        Recipes.compressor.addRecipe(Ic2Items.hydratedCoalDust, Ic2Items.hydratedCoalClump);
        Recipes.compressor.addRecipe(new ItemStack(Block.field_72012_bb, 3), new ItemStack(Block.field_72033_bA));
        Recipes.compressor.addRecipe(new ItemStack(Block.field_71939_E), new ItemStack(Block.field_71957_Q));
        Recipes.compressor.addRecipe(new ItemStack(Item.field_77768_aD), new ItemStack(Block.field_72036_aT));
        Recipes.compressor.addRecipe(Ic2Items.waterCell, new ItemStack(Item.field_77768_aD));
        Recipes.compressor.addRecipe(Ic2Items.mixedMetalIngot, Ic2Items.advancedAlloy);
        Recipes.compressor.addRecipe(Ic2Items.carbonMesh, Ic2Items.carbonPlate);
        Recipes.compressor.addRecipe(Ic2Items.coalBall, Ic2Items.compressedCoalBall);
        Recipes.compressor.addRecipe(Ic2Items.coalChunk, new ItemStack(Item.field_77702_n));
        Recipes.compressor.addRecipe(Ic2Items.constructionFoam, Ic2Items.constructionFoamPellet);
        Recipes.compressor.addRecipe(Ic2Items.cell, Ic2Items.airCell);
    }

    @Override
    public ItemStack getResultFor(ItemStack itemStack, boolean adjustInput) {
        return (ItemStack)Recipes.compressor.getOutputFor(itemStack, adjustInput);
    }

    @Override
    public boolean canOperate() {
        return super.canOperate() || this.getValidPump() != null && this.outputSlot.canAdd(new ItemStack(Item.field_77768_aD));
    }

    @Override
    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        if (this.inputSlot.isEmpty() || this.getResultFor(this.inputSlot.get(), false) == null) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.pumpCharge = 0;
            pump.clearLastBlock();
            this.outputSlot.add(new ItemStack(Item.field_77768_aD));
        } else {
            super.operate();
        }
    }

    public TileEntityPump getValidPump() {
        if (this.validPump != null && !this.validPump.func_70320_p() && this.validPump.pump().itemID == Block.field_71943_B.field_71990_ca) {
            return this.validPump;
        }
        for (Direction dir : Direction.values()) {
            TileEntity te = dir.applyToTileEntity(this);
            if (!(te instanceof TileEntityPump)) continue;
            this.validPump = (TileEntityPump)te;
            if (this.validPump.pump().itemID != Block.field_71943_B.field_71990_ca) continue;
            return this.validPump;
        }
        return null;
    }

    @Override
    public String func_70303_b() {
        return "Compressor";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiCompressor(new ContainerStandardMachine(entityPlayer, this));
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/CompressorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }
}

