/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.item.ElectricItem;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.InvSlotConsumableBlock;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.machine.ContainerMiner;
import ic2.core.block.machine.gui.GuiMiner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.item.tool.ItemElectricToolDDrill;
import ic2.core.item.tool.ItemElectricToolDrill;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeHooks;

public class TileEntityMiner
extends TileEntityElectricMachine
implements IHasGui {
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public short miningTicker = 0;
    private AudioSource audioSource;
    public final InvSlotConsumableId drillSlot;
    public final InvSlotConsumableBlock pipeSlot;
    public final InvSlotConsumableId scannerSlot;

    public TileEntityMiner() {
        super(1000, IC2.enableMinerLapotron ? 3 : 1, 0);
        this.drillSlot = new InvSlotConsumableId((TileEntityInventory)this, "drill", 3, InvSlot.Access.IO, 1, InvSlot.InvSide.TOP, Ic2Items.miningDrill.field_77993_c, Ic2Items.diamondDrill.field_77993_c);
        this.pipeSlot = new InvSlotConsumableBlock(this, "pipe", 2, InvSlot.Access.IO, 1, InvSlot.InvSide.SIDE);
        this.scannerSlot = new InvSlotConsumableId((TileEntityInventory)this, "scanner", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.odScanner.field_77993_c, Ic2Items.ovScanner.field_77993_c);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1 && itemStack.func_77973_b() instanceof ItemScanner) {
            return true;
        }
        if (slot == 2 && itemStack.field_77993_c == Ic2Items.miningPipe.field_77993_c) {
            return true;
        }
        if (slot == 3 && itemStack.func_77973_b() instanceof ItemElectricToolDrill) {
            return true;
        }
        return super.func_94041_b(slot, itemStack);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            --this.energy;
            if (!this.scannerSlot.isEmpty()) {
                this.energy -= ElectricItem.manager.charge(this.scannerSlot.get(), this.energy, 2, false, false);
            }
            if (!this.drillSlot.isEmpty()) {
                this.energy -= ElectricItem.manager.charge(this.drillSlot.get(), this.energy, 1, false, false);
            }
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.drillSlot.isEmpty()) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.energy -= 2;
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.miningTicker = nbttagcompound.func_74765_d("miningTicker");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", (int)((short)this.targetX));
        nbttagcompound.func_74768_a("targetY", (int)((short)this.targetY));
        nbttagcompound.func_74768_a("targetZ", (int)((short)this.targetZ));
        nbttagcompound.func_74777_a("miningTicker", this.miningTicker);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        if (!this.canReachTarget(this.targetX, this.targetY, this.targetZ, true)) {
            int x = this.targetX - this.field_70329_l;
            int z = this.targetZ - this.field_70327_n;
            if (Math.abs(x) > Math.abs(z)) {
                this.targetX = x > 0 ? --this.targetX : ++this.targetX;
            } else {
                this.targetZ = z > 0 ? --this.targetZ : ++this.targetZ;
            }
            return false;
        }
        if (!this.canMine(this.targetX, this.targetY, this.targetZ)) {
            int id = this.field_70331_k.func_72798_a(this.targetX, this.targetY, this.targetZ);
            if ((id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            return false;
        }
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        if (this.drillSlot.get().field_77993_c == Ic2Items.diamondDrill.field_77993_c) {
            this.miningTicker = (short)(this.miningTicker + 3);
            this.energy -= 14;
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public void mineBlock() {
        Item drill = this.drillSlot.get().func_77973_b();
        if (drill instanceof ItemElectricToolDrill) {
            ElectricItem.manager.use(this.drillSlot.get(), 50, null);
        } else if (drill instanceof ItemElectricToolDDrill) {
            ElectricItem.manager.use(this.drillSlot.get(), 80, null);
        }
        int id = this.field_70331_k.func_72798_a(this.targetX, this.targetY, this.targetZ);
        int meta = this.field_70331_k.func_72805_g(this.targetX, this.targetY, this.targetZ);
        boolean liquid = false;
        if (id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) {
            liquid = true;
            if (meta != 0) {
                id = 0;
            }
        }
        if (id != 0) {
            if (!liquid) {
                Block ore = Block.field_71973_m[id];
                StackUtil.distributeDrop(this, ore.getBlockDropped(this.field_70331_k, this.targetX, this.targetY, this.targetZ, meta, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.drillSlot.get())));
            } else {
                if (id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca) {
                    this.usePump(Block.field_71943_B.field_71990_ca);
                }
                if (id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) {
                    this.usePump(Block.field_71938_D.field_71990_ca);
                }
            }
            this.field_70331_k.func_72832_d(this.targetX, this.targetY, this.targetZ, 0, 0, 7);
            this.energy -= 2 * (this.field_70330_m - this.targetY);
        }
        if (this.targetX == this.field_70329_l && this.targetZ == this.field_70327_n) {
            this.field_70331_k.func_72832_d(this.targetX, this.targetY, this.targetZ, Ic2Items.miningPipe.field_77993_c, 0, 7);
            this.energy -= 10;
        }
        this.updateMineTip(this.targetY);
        this.targetY = -1;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n);
        if (blockId != 0) {
            StackUtil.distributeDrop(this, Block.field_71973_m[blockId].getBlockDropped(this.field_70331_k, this.field_70329_l, y, this.field_70327_n, this.field_70331_k.func_72805_g(this.field_70329_l, y, this.field_70327_n), 0));
            this.field_70331_k.func_72832_d(this.field_70329_l, y, this.field_70327_n, 0, 0, 7);
        }
        if (!this.pipeSlot.isEmpty() && this.pipeSlot.get().field_77993_c != Ic2Items.miningPipe.field_77993_c) {
            this.field_70331_k.func_72832_d(this.field_70329_l, y, this.field_70327_n, this.pipeSlot.get().field_77993_c, this.pipeSlot.get().func_77960_j(), 7);
            this.pipeSlot.consume(1);
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.field_70330_m) {
            return;
        }
        int x = this.field_70329_l;
        int z = this.field_70327_n;
        for (int y = this.field_70330_m - 1; y > low; --y) {
            int id = this.field_70331_k.func_72798_a(x, y, z);
            if (id == Ic2Items.miningPipe.field_77993_c || this.pipeSlot.isEmpty()) continue;
            this.field_70331_k.func_72832_d(x, y, z, Ic2Items.miningPipe.field_77993_c, 0, 7);
            this.pipeSlot.consume(1);
        }
        this.field_70331_k.func_72832_d(x, low, z, Ic2Items.miningPipeTip.field_77993_c, 0, 7);
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.field_70329_l == x && this.field_70327_n == z) {
            return true;
        }
        if (!ignore && !this.canPass(this.field_70331_k.func_72798_a(x, y, z))) {
            return false;
        }
        int xdif = x - this.field_70329_l;
        int zdif = z - this.field_70327_n;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.field_70330_m || this.scannerSlot.isEmpty()) {
            this.setTarget(this.field_70329_l, y - 1, this.field_70327_n);
            return;
        }
        int scanrange = ((ItemScanner)this.scannerSlot.get().func_77973_b()).startLayerScan(this.scannerSlot.get());
        if (scanrange > 0) {
            for (int x = this.field_70329_l - scanrange; x <= this.field_70329_l + scanrange; ++x) {
                for (int z = this.field_70327_n - scanrange; z <= this.field_70327_n + scanrange; ++z) {
                    int m;
                    int n = this.field_70331_k.func_72798_a(x, y, z);
                    if ((!ItemScanner.isValuable(n, m = this.field_70331_k.func_72805_g(x, y, z)) || !this.canMine(x, y, z)) && (!this.isAnyPumpConnected() || this.field_70331_k.func_72805_g(x, y, z) != 0 || n != Block.field_71944_C.field_71990_ca && n != Block.field_71938_D.field_71990_ca)) continue;
                    this.setTarget(x, y, z);
                    return;
                }
            }
        }
        this.setTarget(this.field_70329_l, y - 1, this.field_70327_n);
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getPipeTip() {
        int y = this.field_70330_m;
        while (this.field_70331_k.func_72798_a(this.field_70329_l, y - 1, this.field_70327_n) == Ic2Items.miningPipe.field_77993_c || this.field_70331_k.func_72798_a(this.field_70329_l, y - 1, this.field_70327_n) == Ic2Items.miningPipeTip.field_77993_c) {
            --y;
        }
        return y;
    }

    public boolean canPass(int id) {
        return id == 0 || id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca || id == Ic2Items.miner.field_77993_c || id == Ic2Items.miningPipe.field_77993_c || id == Ic2Items.miningPipeTip.field_77993_c;
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        if (this.drillSlot.isEmpty() || this.pipeSlot.isEmpty()) {
            return false;
        }
        if (this.pipeSlot.get().field_77993_c != Ic2Items.miningPipe.field_77993_c) {
            return false;
        }
        return !this.isStuck();
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public boolean canMine(int x, int y, int z) {
        int id = this.field_70331_k.func_72798_a(x, y, z);
        int meta = this.field_70331_k.func_72805_g(x, y, z);
        if (id == 0) {
            return true;
        }
        if (id == Ic2Items.miningPipe.field_77993_c || id == Ic2Items.miningPipeTip.field_77993_c || id == Block.field_72077_au.field_71990_ca) {
            return false;
        }
        if ((id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) && this.isPumpConnected()) {
            return true;
        }
        Block block = Block.field_71973_m[id];
        if (block.func_71934_m(this.field_70331_k, x, y, z) < 0.0f) {
            return false;
        }
        if (block.func_71913_a(meta, false) && block.field_72018_cp.func_76229_l()) {
            return true;
        }
        if (id == Block.field_71955_W.field_71990_ca) {
            return true;
        }
        if (!this.drillSlot.isEmpty()) {
            try {
                HashMap toolClasses = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolClasses"});
                List tc = (List)toolClasses.get(this.drillSlot.get().field_77993_c);
                if (tc == null) {
                    return this.drillSlot.get().func_77987_b(block);
                }
                Object[] ta = tc.toArray();
                String cls = (String)ta[0];
                int hvl = (Integer)ta[1];
                HashMap toolHarvestLevels = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolHarvestLevels"});
                Integer bhl = (Integer)toolHarvestLevels.get(Arrays.asList(block.field_71990_ca, meta, cls));
                if (bhl == null) {
                    return this.drillSlot.get().func_77987_b(block);
                }
                if (bhl > hvl) {
                    return false;
                }
                return this.drillSlot.get().func_77987_b(block);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public boolean canWithdraw() {
        return this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == Ic2Items.miningPipe.field_77993_c || this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) == Ic2Items.miningPipeTip.field_77993_c;
    }

    public boolean isPumpConnected() {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)).canHarvest()) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)).canHarvest()) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)).canHarvest()) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)).canHarvest()) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)).canHarvest()) {
            return true;
        }
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof TileEntityPump;
    }

    public void usePump(int id) {
        for (Direction dir : Direction.values()) {
            TileEntityPump pump;
            TileEntity te = dir.applyToTileEntity(this);
            if (!(te instanceof TileEntityPump) || !(pump = (TileEntityPump)te).canHarvest()) continue;
            pump.operate(new ChunkCoordinates(this.targetX, this.targetY, this.targetZ));
        }
    }

    @Override
    public String func_70303_b() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiMiner(new ContainerMiner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }
}

