/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.personal.ContainerPersonalChest;
import ic2.core.block.personal.GuiPersonalChest;
import ic2.core.block.personal.IPersonalBlock;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileEntityPersonalChest
extends TileEntityInventory
implements IPersonalBlock,
IHasGui {
    private int ticksSinceSync;
    private int numUsingPlayers;
    public float lidAngle;
    public float prevLidAngle;
    public String owner = "null";
    public final InvSlot contentSlot = new InvSlot(this, "content", 0, InvSlot.Access.NONE, 54);

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
    }

    @Override
    public String func_70303_b() {
        return "Personal Safe";
    }

    @Override
    public boolean enableUpdateEntity() {
        return true;
    }

    public void func_70316_g() {
        double var4;
        if (++this.ticksSinceSync % 20 * 4 == 0 && IC2.platform.isSimulating()) {
            this.syncNumUsingPlayers();
        }
        this.prevLidAngle = this.lidAngle;
        float var1 = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double var2 = (double)this.field_70329_l + 0.5;
            var4 = (double)this.field_70327_n + 0.5;
            this.field_70331_k.func_72908_a(var2, (double)this.field_70330_m + 0.5, var4, "random.chestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float var3;
            float var8 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += var1) : (this.lidAngle -= var1);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (var3 = 0.5f) && var8 >= var3) {
                var4 = (double)this.field_70329_l + 0.5;
                double var6 = (double)this.field_70327_n + 0.5;
                this.field_70331_k.func_72908_a(var4, (double)this.field_70330_m + 0.5, var6, "random.chestclosed", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    @Override
    public void func_70305_f() {
        --this.numUsingPlayers;
        this.syncNumUsingPlayers();
    }

    public boolean func_70315_b(int event, int data) {
        if (event == 1) {
            this.numUsingPlayers = data;
            return true;
        }
        return false;
    }

    private void syncNumUsingPlayers() {
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), 1, this.numUsingPlayers);
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        if (!this.permitsAccess(entityPlayer)) {
            return false;
        }
        if (!this.contentSlot.isEmpty()) {
            IC2.platform.messagePlayer(entityPlayer, "Can't wrench non-empty safe");
            return false;
        }
        return true;
    }

    @Override
    public boolean permitsAccess(EntityPlayer player) {
        MinecraftServer server;
        if (player == null) {
            return false;
        }
        if (this.owner.equals("null")) {
            this.owner = player.field_71092_bJ;
            IC2.network.updateTileEntityField(this, "owner");
            return true;
        }
        if (IC2.platform.isSimulating() && (player.field_71092_bJ.equals((server = MinecraftServer.func_71276_C()).func_71214_G()) || server.func_71203_ab().func_72353_e(player.field_71092_bJ))) {
            return true;
        }
        if (this.owner.equalsIgnoreCase(player.field_71092_bJ)) {
            return true;
        }
        if (IC2.platform.isSimulating()) {
            IC2.platform.messagePlayer(player, "This safe is owned by " + this.owner);
        }
        return false;
    }

    @Override
    public boolean permitsAccess(String username) {
        return this.owner.equals(username);
    }

    @Override
    public String getUsername() {
        return this.owner;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPersonalChest(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer) {
        return new GuiPersonalChest(new ContainerPersonalChest(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

