/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;

public class ItemToolWrench
extends ItemIC2 {
    public ItemToolWrench(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77656_e(160);
        this.func_77625_d(1);
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityTerra tileEntityTerra;
        if (!this.canTakeDamage(itemstack, 1)) {
            return false;
        }
        int blockId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockId];
        if (block == null) {
            return false;
        }
        int metaData = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileEntityTerra && (tileEntityTerra = (TileEntityTerra)tileEntity).ejectBlueprint()) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        if (tileEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tileEntity;
            if (IC2.keyboard.isAltKeyDown(entityPlayer)) {
                for (int step = 1; step < 6 && !wrenchable.wrenchCanSetFacing(entityPlayer, side = entityPlayer.func_70093_af() ? (wrenchable.getFacing() + 6 - step) % 6 : (wrenchable.getFacing() + step) % 6); ++step) {
                }
            } else if (entityPlayer.func_70093_af()) {
                side += side % 2 * -2 + 1;
            }
            if (wrenchable.wrenchCanSetFacing(entityPlayer, side)) {
                if (IC2.platform.isSimulating()) {
                    wrenchable.setFacing((short)side);
                    this.damage(itemstack, 1, entityPlayer);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
            if (this.canTakeDamage(itemstack, 10) && wrenchable.wrenchCanRemove(entityPlayer)) {
                if (IC2.platform.isSimulating()) {
                    ItemStack wrenchDrop;
                    if (IC2.enableLoggingWrench) {
                        String blockName = tileEntity.getClass().getName().replace("TileEntity", "");
                        IC2.log.log(Level.INFO, "Player " + entityPlayer.field_71092_bJ + " used the wrench to remove the " + blockName + " (" + blockId + "-" + metaData + ") at " + x + "/" + y + "/" + z);
                    }
                    boolean dropOriginalBlock = false;
                    if (wrenchable.getWrenchDropRate() < 1.0f && this.overrideWrenchSuccessRate(itemstack)) {
                        if (!this.canTakeDamage(itemstack, 200)) {
                            IC2.platform.messagePlayer(entityPlayer, "Not enough energy for lossless wrench operation");
                            return true;
                        }
                        dropOriginalBlock = true;
                        this.damage(itemstack, 200, entityPlayer);
                    } else {
                        dropOriginalBlock = world.field_73012_v.nextFloat() <= wrenchable.getWrenchDropRate();
                        this.damage(itemstack, 10, entityPlayer);
                    }
                    ArrayList drops = block.getBlockDropped(world, x, y, z, metaData, 0);
                    if (dropOriginalBlock && (wrenchDrop = wrenchable.getWrenchDrop(entityPlayer)) != null) {
                        if (drops.isEmpty()) {
                            drops.add(wrenchDrop);
                        } else {
                            drops.set(0, wrenchDrop);
                        }
                    }
                    for (ItemStack itemStack : drops) {
                        StackUtil.dropAsEntity(world, x, y, z, itemStack);
                    }
                    world.func_72832_d(x, y, z, 0, 0, 3);
                }
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
                }
                return IC2.platform.isSimulating();
            }
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            if (IC2.platform.isSimulating()) {
                this.damage(itemstack, 1, entityPlayer);
            }
            if (IC2.platform.isRendering()) {
                IC2.audioManager.playOnce(entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.defaultVolume);
            }
            return IC2.platform.isSimulating();
        }
        return false;
    }

    public boolean shouldPassSneakingClickToBlock(World par2World, int par4, int par5, int par6) {
        return true;
    }

    public void damage(ItemStack is, int damage, EntityPlayer player) {
        is.func_77972_a(damage, (EntityLiving)player);
    }

    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        return false;
    }
}

