/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;

@SideOnly(value=Side.CLIENT)
public abstract class GuiScreenBase
extends GuiContainer {
    protected List _controls = new LinkedList();
    protected String _backgroundTexture;

    public GuiScreenBase(Container container, String backgroundTexture) {
        super(container);
        this._backgroundTexture = backgroundTexture;
    }

    protected void addControl(Control control) {
        this._controls.add(control);
    }

    protected void func_74185_a(float gameTicks, int mouseX, int mouseY) {
        mouseX -= this.field_74198_m;
        mouseY -= this.field_74197_n;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(this._backgroundTexture);
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_74198_m, (float)this.field_74197_n, (float)0.0f);
        for (Control c : this._controls) {
            if (!c.getVisible()) continue;
            c.drawBackground(mouseX, mouseY, gameTicks);
        }
        GL11.glPopMatrix();
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        super.func_74189_g(mouseX, mouseY);
        mouseX -= this.field_74198_m;
        mouseY -= this.field_74197_n;
        for (Control c : this._controls) {
            if (!c.getVisible()) continue;
            c.drawForeground(mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        mouseX -= this.field_74198_m;
        mouseY -= this.field_74197_n;
        for (Control c : this._controls) {
            if (!c.getVisible() || !c.getEnabled()) continue;
            c.drawTooltip(mouseX, mouseY, gameTicks);
        }
        for (int i = this._controls.size() - 1; i >= 0; --i) {
            Control c;
            c = (Control)this._controls.get(i);
            if (!c.visible || !c.enabled) continue;
            c.updateTick(mouseX, mouseY);
        }
    }

    public void func_73867_d() {
        super.func_73867_d();
        int mouseX = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c - this.field_74198_m;
        int mouseY = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1 - this.field_74197_n;
        int wheelMovement = Mouse.getEventDWheel();
        if (wheelMovement != 0) {
            for (int i = this._controls.size() - 1; i >= 0; --i) {
                Control c = (Control)this._controls.get(i);
                if (!c.isPointInBounds(mouseX, mouseY) || !c.visible || !c.enabled || !c.onMouseWheel(mouseX, mouseY, wheelMovement)) continue;
                return;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.field_74198_m;
        mouseY -= this.field_74197_n;
        for (int i = this._controls.size() - 1; i >= 0; --i) {
            Control c = (Control)this._controls.get(i);
            if (!c.isPointInBounds(mouseX, mouseY) || !c.visible || !c.enabled || !c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            return;
        }
        super.func_73864_a(mouseX += this.field_74198_m, mouseY += this.field_74197_n, mouseButton);
    }

    protected void func_73879_b(int mouseX, int mouseY, int event) {
        mouseX -= this.field_74198_m;
        mouseY -= this.field_74197_n;
        if (event == 0 || event == 1) {
            for (int i = this._controls.size() - 1; i >= 0; --i) {
                Control c = (Control)this._controls.get(i);
                if (!c.visible || !c.enabled) continue;
                c.onMouseReleased(mouseX, mouseY);
            }
        }
        super.func_73879_b(mouseX += this.field_74198_m, mouseY += this.field_74197_n, event);
    }

    protected void func_73869_a(char characterTyped, int keyPressed) {
        for (int i = this._controls.size() - 1; i >= 0; --i) {
            Control c = (Control)this._controls.get(i);
            if (!c.visible || !c.enabled || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    protected boolean isPointInArea(int x1, int y1, int width, int height, int px, int py) {
        return px >= x1 - 1 && px < x1 + width + 1 && py >= y1 - 1 && py < y1 + height + 1;
    }
}

