/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import need4speed402.mods.barrels.BlockBarrel;
import need4speed402.mods.barrels.ItemBarrel;
import need4speed402.mods.barrels.PacketHandler;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.proxy.Proxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@NetworkMod(clientSideRequired=true, channels={"barrelsModUpdate"}, packetHandler=PacketHandler.class)
@Mod(modid="barrels", name="The Barrels Mod", version="2.2.2")
public class Barrels {
    @Mod.Instance(value="barrels")
    public static Barrels instance;
    @SidedProxy(serverSide="need4speed402.mods.barrels.proxy.Proxy", clientSide="need4speed402.mods.barrels.proxy.ProxyClient")
    public static Proxy proxy;
    public BlockBarrel barrel;
    public ItemStack T1barrel;
    public ItemStack T2barrel;
    public ItemStack T3barrel;
    public int T1BarrelMaxStorage = 64;
    public int T2BarrelMaxStorage = 1024;
    public int T3BarrelMaxStorage = 4096;
    public String T1barrelCrafting = "shaped;logWood;logWood;logWood;item,ingotIron;nothing;item,ingotIron;logWood;logWood;logWood";
    public String T2barrelCrafting = "shaped;item,blazeRod;block,obsidian;item,blazeRod;item,enderPearl;barrel,T1barrel;item,enderPearl;item,blazeRod;block,obsidian;item,blazeRod";
    public String T3barrelCrafting = "shaped;block,obsidian;item,blazeRod;block,obsidian;item,diamond;barrel,T2barrel;item,diamond;block,obsidian;item,blazeRod;block,obsidian";
    public HashMap prefix = new HashMap();
    public HashMap suffix = new HashMap();
    public boolean onlyRenderOneSide = false;
    public boolean renderMapInfo = true;
    public boolean renderIn3D = true;
    public boolean leaveOneItem = false;
    public byte[] interaction = new byte[6];

    @Mod.PreInit
    public void preLoad(FMLPreInitializationEvent event) {
        instance = this;
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            int id = cfg.get("block", "Barrel", 4000, "The block ID for barrels.").getInt();
            if (id > Block.field_71973_m.length) {
                throw new Exception("Block id too big! Must be below " + Block.field_71973_m.length + "!");
            }
            this.barrel = new BlockBarrel(id);
            this.T1barrel = new ItemStack((Block)this.barrel, 1, 0);
            this.T2barrel = new ItemStack((Block)this.barrel, 1, 1);
            this.T3barrel = new ItemStack((Block)this.barrel, 1, 2);
            this.T1BarrelMaxStorage = cfg.get("BarrelStorage", "T1BarrelMaxStorage", this.T1BarrelMaxStorage, "The maximum stacks of items that a barrel can hold.\n Set any value to -1 and that type of barrel will be disabled.").getInt();
            this.T2BarrelMaxStorage = cfg.get("BarrelStorage", "T2BarrelMaxStorage", this.T2BarrelMaxStorage).getInt();
            this.T3BarrelMaxStorage = cfg.get("BarrelStorage", "T3BarrelMaxStorage", this.T3BarrelMaxStorage).getInt();
            String catagory = "render";
            this.onlyRenderOneSide = cfg.get(catagory, "onlyRenderOneSide", this.onlyRenderOneSide).getBoolean(this.onlyRenderOneSide);
            this.renderMapInfo = cfg.get(catagory, "renderMapInfo", this.renderMapInfo).getBoolean(this.renderMapInfo);
            this.renderIn3D = cfg.get(catagory, "renderIn3D", this.renderIn3D).getBoolean(this.renderIn3D);
            String[] modes = cfg.get("interaction", "interaction", "in/out;in/out;unused;unused;unused;unused", "How the barrels interact with outside sources (buildcraft pipes)\n Usage: can be in four states: in, out, in/out, unused\n Formatting: <up>;<down>;<back>;<forward>;<right>;<left>").getString().split(";");
            for (int index = 0; index < modes.length; ++index) {
                int mode = 0;
                if (modes[index].equals("in")) {
                    mode = 1;
                } else if (modes[index].equals("out")) {
                    mode = 2;
                } else if (modes[index].equals("in/out")) {
                    mode = 3;
                }
                this.interaction[index] = mode;
            }
            this.leaveOneItem = cfg.get("interaction", "leaveOneItem", this.leaveOneItem).getBoolean(this.leaveOneItem);
            this.T1barrelCrafting = cfg.get("crafting", "T1barrelCrafting", this.T1barrelCrafting, "This allowes you to chage the crafting recipeis.\n Look on the forum for tutorials on setting this up.").getString();
            this.T2barrelCrafting = cfg.get("crafting", "T2barrelCrafting", this.T2barrelCrafting).getString();
            this.T3barrelCrafting = cfg.get("crafting", "T3barrelCrafting", this.T3barrelCrafting).getString();
        }
        catch (Exception e) {
            System.err.println("There has been a problem with the initialization of Barrels!");
            throw new RuntimeException(e);
        }
        finally {
            cfg.save();
        }
        proxy.initializeRendering();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityBarrel.class, "tileBarrels");
        GameRegistry.registerBlock((Block)this.barrel, ItemBarrel.class, (String)"block.barrel", (String)"barrels");
        proxy.loadLanguageFiles();
    }

    @Mod.PostInit
    public void postLoad(FMLPostInitializationEvent event) throws Exception {
        if (this.T1BarrelMaxStorage != -1) {
            this.addRecipe(this.T1barrel, this.T1barrelCrafting);
        }
        if (this.T2BarrelMaxStorage != -1) {
            this.addRecipe(this.T2barrel, this.T2barrelCrafting);
        }
        if (this.T3BarrelMaxStorage != -1) {
            this.addRecipe(this.T3barrel, this.T3barrelCrafting);
        }
    }

    public void addRecipe(ItemStack result, String code) {
        block43: {
            String nothingSymbol = "nothing";
            try {
                int i;
                if (code == null || code.length() == 0) {
                    return;
                }
                String[] element = code.split(";");
                if (element.length != 10) {
                    throw new IllegalArgumentException("Insuficent information");
                }
                ArrayList<Object> list = new ArrayList<Object>();
                int startY = 0;
                int endY = 3;
                int startX = 0;
                int endX = 3;
                boolean started = true;
                boolean ended = true;
                for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    if (started && element[i * 3 + 1].equals("nothing") && element[i * 3 + 2].equals("nothing") && element[i * 3 + 3].equals("nothing")) {
                        startY = (byte)(startY + 1);
                    } else {
                        started = false;
                    }
                    if (ended && element[9 - i * 3].equals("nothing") && element[8 - i * 3].equals("nothing") && element[7 - i * 3].equals("nothing")) {
                        endY = (byte)(endY - 1);
                        continue;
                    }
                    ended = false;
                }
                started = true;
                ended = true;
                for (i = 0; i < 3; ++i) {
                    if (started && element[i + 1].equals("nothing") && element[i + 4].equals("nothing") && element[i + 7].equals("nothing")) {
                        startX = (byte)(startX + 1);
                    } else {
                        started = false;
                    }
                    if (ended && element[3 - i].equals("nothing") && element[6 - i].equals("nothing") && element[9 - i].equals("nothing")) {
                        endX = (byte)(endX - 1);
                        continue;
                    }
                    ended = false;
                }
                boolean isShapeless = element[0].equals("shapeless");
                for (int i2 = startY; i2 < endY; ++i2) {
                    if (!isShapeless) {
                        list.add(i2 - startY, "");
                    }
                    for (int ii = startX; ii < endX; ++ii) {
                        int index = i2 * 3 + ii + 1;
                        boolean isNothing = element[index].equals("nothing");
                        if (!isShapeless) {
                            String string = null;
                            string = isNothing ? " " : Integer.toString(index);
                            if (i2 - startY == 0) {
                                list.set(0, list.get(0) + string);
                            } else if (i2 - startY == 1) {
                                list.set(1, list.get(1) + string);
                            } else if (i2 - startY == 2) {
                                list.set(2, list.get(2) + string);
                            }
                        }
                        if (isNothing) continue;
                        if (!isShapeless) {
                            list.add(Character.valueOf(Integer.toString(index).charAt(0)));
                        }
                        Object crafting = null;
                        if (element[index].contains(",")) {
                            String[] subList = element[index].split(",");
                            if (subList[0].equals("block")) {
                                for (Block block : Block.field_71973_m) {
                                    if (block == null || block.func_71917_a() == null || !block.func_71917_a().equals("tile." + subList[1])) continue;
                                    crafting = new ItemStack(block, 1, subList.length == 3 ? Integer.parseInt(subList[2]) : 0);
                                    break;
                                }
                            } else if (subList[0].equals("item")) {
                                for (Block block : Item.field_77698_e) {
                                    if (block == null || block.func_77658_a() == null || !block.func_77658_a().equals("item." + subList[1])) continue;
                                    crafting = new ItemStack((Item)block, 1, subList.length == 3 ? Integer.parseInt(subList[2]) : 0);
                                    break;
                                }
                            } else if (subList[0].equals("barrel")) {
                                crafting = this.getClass().getField(subList[1]).get(this);
                            } else if (subList[0].equals("blockid") || subList[0].equals("itemid")) {
                                crafting = new ItemStack(Integer.parseInt(subList[1]), 1, subList.length == 3 ? Integer.parseInt(subList[2]) : 0);
                            } else {
                                crafting = Class.forName(subList[0]).getField(subList[1]).get(null);
                                if (!(crafting instanceof ItemStack)) {
                                    if (crafting instanceof Block) {
                                        crafting = new ItemStack((Block)crafting, 1, subList.length == 3 ? Integer.parseInt(subList[2]) : 0);
                                    } else if (crafting instanceof Item) {
                                        crafting = new ItemStack((Item)crafting, 1, subList.length == 3 ? Integer.parseInt(subList[2]) : 0);
                                    } else if (!(crafting instanceof String)) {
                                        throw new IllegalArgumentException("Wrong type.");
                                    }
                                }
                            }
                        } else {
                            crafting = element[index];
                        }
                        list.add(crafting);
                    }
                }
                if (element[0].equals("shaped")) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, list.toArray()));
                    break block43;
                }
                if (isShapeless) {
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, list.toArray()));
                    break block43;
                }
                throw new IllegalArgumentException("Type of crafting has not been specified.");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e.toString() + ": There was a problem while adding a recipe. Plase make sure your configuratons are correct.");
            }
        }
    }

    static {
        proxy = new Proxy();
    }
}

