/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import need4speed402.mods.barrels.EntityItemFrame;
import need4speed402.mods.barrels.TileEntityBarrel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandler
implements IPacketHandler {
    public static PacketHandler instance = new PacketHandler();
    public static final String NETWORK_CHANNEL = "barrelsModUpdate";

    public void updateClients(ItemStack item, int side, EntityItemFrame[] attachedFrames, int x, int y, int z, int dimID) throws IOException {
        PacketDispatcher.sendPacketToAllInDimension((Packet)new Packet250CustomPayload(NETWORK_CHANNEL, this.serialize(x, y, z, item, side, attachedFrames)), (int)dimID);
    }

    public void updateClient(ItemStack item, int side, EntityItemFrame[] attachedFrames, int x, int y, int z, Player client) throws IOException {
        PacketDispatcher.sendPacketToPlayer((Packet)new Packet250CustomPayload(NETWORK_CHANNEL, this.serialize(x, y, z, item, side, attachedFrames)), (Player)client);
    }

    private byte[] serialize(int x, int y, int z, ItemStack item, int side, EntityItemFrame[] attachedFrames) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(x);
        data.writeInt(y);
        data.writeInt(z);
        int size = 0;
        boolean sendAsBlock = item != null && item.field_77993_c < 4096 && item.func_77960_j() < 16;
        int packed = 0;
        if (attachedFrames != null) {
            for (i = 0; i < attachedFrames.length; ++i) {
                if (attachedFrames[i] == null) continue;
                packed |= 0x80;
                break;
            }
        }
        if (item == null) {
            packed |= 0x40;
        } else {
            if (item.func_77978_p() != null) {
                packed |= 0x20;
            }
            if (sendAsBlock) {
                packed |= 0x10;
            }
            size = item.field_77994_a < 255 ? 0 : (item.field_77994_a < 65535 ? 1 : (item.field_77994_a < 0xFFFFFF ? 2 : 3));
            packed |= size << 2;
        }
        data.write(packed |= side & 3);
        if (attachedFrames != null) {
            packed = 0;
            for (i = 0; i < attachedFrames.length; ++i) {
                if (attachedFrames[i] == null) continue;
                packed = (byte)(packed | 1 << i);
            }
            if (packed != 0) {
                data.write(packed);
            }
        }
        if (item != null) {
            if (sendAsBlock) {
                data.write(item.field_77993_c >> 4);
                data.write(item.field_77993_c << 4 | item.func_77960_j());
            } else {
                data.writeShort(item.field_77993_c);
                data.writeInt(item.func_77960_j());
            }
            for (int i2 = 0; i2 <= size; ++i2) {
                data.write(item.field_77994_a >> i2 * 8);
            }
            if (item.func_77978_p() != null) {
                NBTBase.func_74731_a((NBTBase)item.func_77978_p(), (DataOutput)data);
            }
        }
        return out.toByteArray();
    }

    public void sendClientsBlockChange(int metadata, int side, int x, int y, int z, int dimID) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(x);
        data.writeInt(y);
        data.writeInt(z);
        data.write(0x80 | (metadata & 0xF) << 2 | side & 3);
        PacketDispatcher.sendPacketToAllInDimension((Packet)new Packet250CustomPayload(NETWORK_CHANNEL, out.toByteArray()), (int)dimID);
    }

    public void sendClientsFrameChange(int x, int y, int z, int dimID, EntityItemFrame[] frames) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(x);
        data.writeInt(y);
        data.writeInt(z);
        int packed = -64;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] == null) continue;
            packed = (byte)(packed | 1 << i);
        }
        data.write(packed);
        PacketDispatcher.sendPacketToAllInDimension((Packet)new Packet250CustomPayload(NETWORK_CHANNEL, out.toByteArray()), (int)dimID);
    }

    public void sendServerRequestForItem(int x, int y, int z) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(x);
        data.writeInt(y);
        data.writeInt(z);
        PacketDispatcher.sendPacketToServer((Packet)new Packet250CustomPayload(NETWORK_CHANNEL, out.toByteArray()));
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            if (!packet.field_73630_a.equals(NETWORK_CHANNEL)) {
                return;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(packet.field_73629_c);
            DataInputStream data = new DataInputStream(in);
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            World world = ((EntityPlayer)player).field_70170_p;
            TileEntityBarrel tile = null;
            TileEntity entity = world.func_72796_p(x, y, z);
            if (entity == null || !(entity instanceof TileEntityBarrel)) {
                return;
            }
            tile = (TileEntityBarrel)entity;
            if (world.field_72995_K) {
                int packed = data.read();
                if (packet.field_73628_b == 13 && (packed & 0x80) != 0) {
                    if ((packed & 0x40) != 0) {
                        int frames = packed & 0xF;
                        for (int i = 0; i < tile.frames.length; ++i) {
                            if ((frames & 1 << i) != 0) {
                                if (tile.frames[i] != null) continue;
                                tile.frames[i] = new EntityItemFrame(world, x, y, z, i);
                                ItemStack stack = tile.getItem();
                                if (stack == null) continue;
                                stack.field_77994_a = 1;
                                tile.frames[i].func_82334_a(stack);
                                continue;
                            }
                            tile.frames[i] = null;
                        }
                    } else {
                        int metadata = (packed & 0x3C) >> 2;
                        if (tile.field_70325_p != metadata) {
                            tile.field_70325_p = metadata;
                            world.func_72921_c(x, y, z, metadata, 0);
                            world.func_72902_n(x, y, z);
                            world.func_96440_m(x, y, z, world.func_72798_a(x, y, z));
                        }
                        tile.setSide((byte)(packed & 3));
                    }
                } else {
                    int frames = -1;
                    if ((packed & 0x80) != 0) {
                        frames = data.read();
                    }
                    if ((packed & 0x40) != 0) {
                        tile.setItem(null);
                    } else {
                        int blockid = 0;
                        int metadata = 0;
                        int stackSize = 0;
                        if ((packed & 0x10) != 0) {
                            blockid = data.read() << 4;
                            int blah = data.read();
                            blockid |= blah >> 4;
                            metadata = blah & 0xF;
                        } else {
                            blockid = data.readUnsignedShort();
                            metadata = data.readInt();
                        }
                        for (int i = 0; i <= (packed & 0xC) >> 2; ++i) {
                            stackSize |= data.read() << i * 8;
                        }
                        ItemStack item = new ItemStack(blockid, stackSize, metadata);
                        if ((packed & 0x20) != 0) {
                            item.func_77982_d((NBTTagCompound)NBTBase.func_74739_b((DataInput)data));
                        }
                        tile.setItem(item);
                    }
                    if (frames != -1) {
                        for (int i = 0; i < tile.frames.length; ++i) {
                            if ((frames & 1 << i) != 0) {
                                if (tile.frames[i] != null) continue;
                                tile.frames[i] = new EntityItemFrame(world, x, y, z, i);
                                ItemStack stack = tile.getItem();
                                if (stack == null) continue;
                                stack.field_77994_a = 1;
                                tile.frames[i].func_82334_a(stack);
                                continue;
                            }
                            tile.frames[i] = null;
                        }
                    }
                    tile.setSide((byte)(packed & 3));
                }
            } else {
                this.updateClient(tile.getItem(), tile.getSide(), tile.frames, x, y, z, player);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

