/*
 * Decompiled with CFR 0.152.
 */
package need4speed402.mods.barrels.proxy;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import need4speed402.mods.barrels.BarrelRender;
import need4speed402.mods.barrels.Barrels;
import need4speed402.mods.barrels.TileEntityBarrel;
import need4speed402.mods.barrels.proxy.Proxy;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.StringTranslate;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    @Override
    public void initializeRendering() {
        TileEntityRenderer.field_76963_a.field_76966_m.put(TileEntityBarrel.class, BarrelRender.instance);
        BarrelRender.instance.func_76893_a(TileEntityRenderer.field_76963_a);
    }

    @Override
    public void loadLanguageFiles() {
        try {
            ArrayList<String> languages = new ArrayList<String>();
            ArrayList<InputStream> languageFiles = new ArrayList<InputStream>();
            try {
                File file = new File(ProxyClient.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()));
                if (file.getPath().endsWith(".class")) {
                    file = new File(file.getPath().substring(0, file.getPath().lastIndexOf(this.getClass().getPackage().getName().replace(".", File.separator))));
                }
                if (file.isDirectory()) {
                    file = new File(file, "lang/barrels");
                    for (File f : file.listFiles()) {
                        languages.add(f.getName().substring(0, f.getName().lastIndexOf(46)));
                        languageFiles.add(new BufferedInputStream(new FileInputStream(f)));
                    }
                } else {
                    JarEntry entry;
                    JarInputStream in = new JarInputStream(new BufferedInputStream(new FileInputStream(file)));
                    while ((entry = in.getNextJarEntry()) != null) {
                        int len;
                        if (!entry.getName().startsWith("lang/barrels/") || entry.getName().endsWith("/")) continue;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        languages.add(entry.getName().substring(entry.getName().lastIndexOf(47) + 1, entry.getName().lastIndexOf(46)));
                        languageFiles.add(new ByteArrayInputStream(out.toByteArray()));
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                for (String lang : StringTranslate.func_74808_a().func_74806_b().keySet()) {
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream("lang/barrels/" + lang + ".lang");
                    if (stream == null) continue;
                    languages.add(lang);
                    languageFiles.add(stream);
                }
            }
            for (int i = 0; i < Math.min(languages.size(), languageFiles.size()); ++i) {
                Properties prop = new Properties();
                prop.load((InputStream)languageFiles.get(i));
                if (Barrels.instance.T1BarrelMaxStorage != -1) {
                    LanguageRegistry.instance().addNameForObject(Barrels.instance.T1barrel, (String)languages.get(i), prop.getProperty("T1barrel"));
                }
                if (Barrels.instance.T2BarrelMaxStorage != -1) {
                    LanguageRegistry.instance().addNameForObject(Barrels.instance.T2barrel, (String)languages.get(i), prop.getProperty("T2barrel"));
                }
                if (Barrels.instance.T3BarrelMaxStorage != -1) {
                    LanguageRegistry.instance().addNameForObject(Barrels.instance.T3barrel, (String)languages.get(i), prop.getProperty("T3barrel"));
                }
                Barrels.instance.prefix.put(languages.get(i), prop.getProperty("prefix"));
                Barrels.instance.suffix.put(languages.get(i), prop.getProperty("suffix"));
                ((InputStream)languageFiles.get(i)).close();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to init names");
            e.printStackTrace();
        }
    }

    private static String decode(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    sb.append(new String(new byte[]{Byte.parseByte(s.substring(i + 1, i + 3), 16)}, 0, 1, "UTF-8"));
                    i += 2;
                }
                catch (Exception e) {
                    sb.append(c);
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

