/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.configuration.ConfigurationHandler;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.core.util.LocalizationUtil;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;

public class CommandSounds {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length <= 0) throw new WrongUsageException("ee3 sounds [ all | self | off ]", new Object[0]);
        String subCommand = args[0];
        if (subCommand.toLowerCase().equals("all")) {
            CommandSounds.processAllCommand(commandSender);
            return;
        } else if (subCommand.toLowerCase().equals("self")) {
            CommandSounds.processSelfCommand(commandSender);
            return;
        } else {
            if (!subCommand.toLowerCase().equals("off")) throw new WrongUsageException("ee3 sounds [ all | self | off ]", new Object[0]);
            CommandSounds.processOffCommand(commandSender);
        }
    }

    private static void processAllCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "all";
        ConfigurationHandler.set("audio", "sounds.enabled", "all");
        commandSender.func_70006_a("\u00a77" + LocalizationUtil.getLocalizedString("command.ee3.sounds.set_to_all"));
    }

    private static void processSelfCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "self";
        ConfigurationHandler.set("audio", "sounds.enabled", "self");
        commandSender.func_70006_a("\u00a77" + LocalizationUtil.getLocalizedString("command.ee3.sounds.set_to_self"));
    }

    private static void processOffCommand(ICommandSender commandSender) {
        ConfigurationSettings.ENABLE_SOUNDS = "off";
        ConfigurationHandler.set("audio", "sounds.enabled", "off");
        commandSender.func_70006_a("\u00a77" + LocalizationUtil.getLocalizedString("command.ee3.sounds.turned_off"));
    }
}

