/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.util;

import com.pahimar.ee3.core.util.GeneralHelper;
import com.pahimar.ee3.core.util.OreStack;
import com.pahimar.ee3.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemUtil {
    private static double rand;

    public static String toString(ItemStack itemStack) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("itemID: %d, metaData: %d, stackSize: %d, itemName: %s, className: %s", itemStack.field_77993_c, itemStack.func_77960_j(), itemStack.field_77994_a, itemStack.func_77977_a(), itemStack.func_77973_b().getClass().toString()));
        return stringBuilder.toString();
    }

    public static boolean compare(ItemStack first, ItemStack second) {
        if (first != null && second != null && first.field_77993_c == second.field_77993_c) {
            if (first.func_77960_j() == Short.MAX_VALUE || second.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            if (first.func_77960_j() == second.func_77960_j() && first.field_77994_a == second.field_77994_a) {
                if (first.func_77942_o() || second.func_77942_o()) {
                    if (!first.func_77942_o() || !second.func_77942_o()) {
                        return false;
                    }
                    return first.func_77978_p().equals((Object)second.func_77978_p());
                }
                return true;
            }
        }
        return false;
    }

    public static ArrayList collateStacks(List unCollatedStacks) {
        ArrayList collatedStacks = new ArrayList();
        for (int i = 0; i < unCollatedStacks.size(); ++i) {
            if (collatedStacks.size() == 0) {
                collatedStacks.add(unCollatedStacks.get(i));
                continue;
            }
            boolean found = false;
            for (int j = 0; j < collatedStacks.size(); ++j) {
                Object collatedStack;
                Object unCollatedStack;
                if (unCollatedStacks.get(i) instanceof ItemStack && collatedStacks.get(j) instanceof ItemStack) {
                    unCollatedStack = (ItemStack)unCollatedStacks.get(i);
                    if (!ItemUtil.compare(unCollatedStack, collatedStack = (ItemStack)collatedStacks.get(j))) continue;
                    ++((ItemStack)collatedStacks.get((int)j)).field_77994_a;
                    found = true;
                    continue;
                }
                if (!(unCollatedStacks.get(i) instanceof OreStack) || !(collatedStacks.get(j) instanceof OreStack) || !OreStack.compareStacks((OreStack)(unCollatedStack = (OreStack)unCollatedStacks.get(i)), (OreStack)(collatedStack = (OreStack)collatedStacks.get(j)))) continue;
                ++((OreStack)collatedStacks.get((int)j)).stackSize;
                found = true;
            }
            if (found) continue;
            collatedStacks.add(unCollatedStacks.get(i));
        }
        return collatedStacks;
    }

    public static boolean hasColor(ItemStack itemStack) {
        return !itemStack.func_77942_o() ? false : (!itemStack.func_77978_p().func_74764_b("display") ? false : itemStack.func_77978_p().func_74775_l("display").func_74764_b("color"));
    }

    public static int getColor(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
        if (nbtTagCompound == null) {
            return Integer.parseInt("ffffff", 16);
        }
        NBTTagCompound displayTagCompound = nbtTagCompound.func_74775_l("display");
        return displayTagCompound == null ? Integer.parseInt("ffffff", 16) : (displayTagCompound.func_74764_b("color") ? displayTagCompound.func_74762_e("color") : Integer.parseInt("ffffff", 16));
    }

    public static void setColor(ItemStack itemStack, int color) {
        if (itemStack != null) {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (nbtTagCompound == null) {
                nbtTagCompound = new NBTTagCompound();
                itemStack.func_77982_d(nbtTagCompound);
            }
            NBTTagCompound colourTagCompound = nbtTagCompound.func_74775_l("display");
            if (!nbtTagCompound.func_74764_b("display")) {
                nbtTagCompound.func_74766_a("display", colourTagCompound);
            }
            colourTagCompound.func_74768_a("color", color);
        }
    }

    public static void dropMiniumShard(EntityPlayer player, EntityLiving entity) {
        if (GeneralHelper.isHostileEntity(entity) && (rand = Math.random()) < 0.15) {
            entity.func_70025_b(ModItems.miniumShard.field_77779_bT, 1);
        }
    }
}

