/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.util;

import com.pahimar.ee3.configuration.ConfigurationHandler;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.core.util.LogHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;

public class VersionHelper
implements Runnable {
    private static VersionHelper instance = new VersionHelper();
    private static final String REMOTE_VERSION_XML_FILE = "https://raw.github.com/pahimar/Equivalent-Exchange-3/master/version.xml";
    public static Properties remoteVersionProperties = new Properties();
    public static final byte UNINITIALIZED = 0;
    public static final byte CURRENT = 1;
    public static final byte OUTDATED = 2;
    public static final byte ERROR = 3;
    public static final byte FINAL_ERROR = 4;
    public static final byte MC_VERSION_NOT_FOUND = 5;
    private static byte result = 0;
    public static String remoteVersion = null;
    public static String remoteUpdateLocation = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVersion() {
        InputStream remoteVersionRepoStream = null;
        result = 0;
        try {
            URL remoteVersionURL = new URL(REMOTE_VERSION_XML_FILE);
            remoteVersionRepoStream = remoteVersionURL.openStream();
            remoteVersionProperties.loadFromXML(remoteVersionRepoStream);
            String remoteVersionProperty = remoteVersionProperties.getProperty(Loader.instance().getMCVersionString());
            if (remoteVersionProperty != null) {
                String[] remoteVersionTokens = remoteVersionProperty.split("\\|");
                if (remoteVersionTokens.length >= 2) {
                    remoteVersion = remoteVersionTokens[0];
                    remoteUpdateLocation = remoteVersionTokens[1];
                } else {
                    result = (byte)3;
                }
                if (remoteVersion != null) {
                    if (!ConfigurationSettings.LAST_DISCOVERED_VERSION.equalsIgnoreCase(remoteVersion)) {
                        ConfigurationHandler.set("general", "version_check.last_discovered_version", remoteVersion);
                    }
                    result = remoteVersion.equalsIgnoreCase(VersionHelper.getVersionForCheck()) ? (byte)1 : (byte)2;
                }
            } else {
                result = (byte)5;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (result == 0) {
                result = (byte)3;
            }
            try {
                if (remoteVersionRepoStream != null) {
                    remoteVersionRepoStream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private static String getVersionForCheck() {
        String[] versionTokens = "pre1h (build 16)".split(" ");
        if (versionTokens.length >= 1) {
            return versionTokens[0];
        }
        return "pre1h (build 16)";
    }

    public static void logResult() {
        if (result == 1 || result == 2) {
            LogHelper.log(Level.INFO, VersionHelper.getResultMessage());
        } else {
            LogHelper.log(Level.WARNING, VersionHelper.getResultMessage());
        }
    }

    public static String getResultMessage() {
        if (result == 0) {
            return LanguageRegistry.instance().getStringLocalization("version.uninitialized");
        }
        if (result == 1) {
            String returnString = LanguageRegistry.instance().getStringLocalization("version.current");
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            return returnString;
        }
        if (result == 2 && remoteVersion != null && remoteUpdateLocation != null) {
            String returnString = LanguageRegistry.instance().getStringLocalization("version.outdated");
            returnString = returnString.replace("@MOD_NAME@", "Equivalent Exchange 3");
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            returnString = returnString.replace("@MOD_UPDATE_LOCATION@", remoteUpdateLocation);
            return returnString;
        }
        if (result == 2 && remoteVersion != null && remoteUpdateLocation != null) {
            String returnString = LanguageRegistry.instance().getStringLocalization("version.outdated");
            returnString = returnString.replace("@MOD_NAME@", "Equivalent Exchange 3");
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            returnString = returnString.replace("@MOD_UPDATE_LOCATION@", remoteUpdateLocation);
            return returnString;
        }
        if (result == 3) {
            return LanguageRegistry.instance().getStringLocalization("version.general_error");
        }
        if (result == 4) {
            return LanguageRegistry.instance().getStringLocalization("version.final_error");
        }
        if (result == 5) {
            String returnString = LanguageRegistry.instance().getStringLocalization("version.mc_version_not_found");
            returnString = returnString.replace("@MOD_NAME@", "Equivalent Exchange 3");
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            return returnString;
        }
        result = (byte)3;
        return LanguageRegistry.instance().getStringLocalization("version.general_error");
    }

    public static String getResultMessageForClient() {
        String returnString = LanguageRegistry.instance().getStringLocalization("version.outdated");
        returnString = returnString.replace("@MOD_NAME@", "\u00a7eEquivalent Exchange 3\u00a7f");
        returnString = returnString.replace("@REMOTE_MOD_VERSION@", "\u00a7e" + remoteVersion + "\u00a7f");
        returnString = returnString.replace("@MINECRAFT_VERSION@", "\u00a7e" + Loader.instance().getMCVersionString() + "\u00a7f");
        returnString = returnString.replace("@MOD_UPDATE_LOCATION@", "\u00a7e" + remoteUpdateLocation + "\u00a7f");
        return returnString;
    }

    public static byte getResult() {
        return result;
    }

    @Override
    public void run() {
        LogHelper.log(Level.INFO, LanguageRegistry.instance().getStringLocalization("version.init_log_message") + " " + REMOTE_VERSION_XML_FILE);
        try {
            for (int count = 0; count < 2 && (result == 0 || result == 3); ++count) {
                VersionHelper.checkVersion();
                VersionHelper.logResult();
                if (result != 0 && result != 3) continue;
                Thread.sleep(10000L);
            }
            if (result == 3) {
                result = (byte)4;
                VersionHelper.logResult();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void execute() {
        new Thread(instance).start();
    }
}

