/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.emc;

import com.pahimar.ee3.emc.EmcComponent;
import com.pahimar.ee3.emc.EmcType;
import java.util.ArrayList;
import java.util.List;

public class EmcValue {
    private float value;
    private float recoveryPercentage;
    private List emcComponents;

    public EmcValue() {
        this.value = 0.0f;
        this.recoveryPercentage = 1.0f;
        this.emcComponents = new ArrayList();
    }

    public EmcValue(float value) {
        this.value = value;
        this.recoveryPercentage = 1.0f;
        this.emcComponents = new ArrayList();
    }

    public EmcValue(float value, float recoveryPercentage) {
        this.value = value;
        this.recoveryPercentage = recoveryPercentage;
        this.emcComponents = new ArrayList();
    }

    public EmcValue(float value, float recoveryPercentage, List emcComponents) {
        this.value = value;
        this.recoveryPercentage = recoveryPercentage;
        this.emcComponents = emcComponents;
    }

    public float getValue() {
        return this.value;
    }

    public float getRecoveryPercentage() {
        return this.recoveryPercentage;
    }

    public List getComponents() {
        return this.emcComponents;
    }

    public EmcComponent getComponent(EmcType emcType) {
        for (EmcComponent emcComponent : this.emcComponents) {
            if (!emcComponent.getEmcType().equals((Object)emcType)) continue;
            return emcComponent;
        }
        return null;
    }

    public boolean containsEmcType(EmcType emcType) {
        for (EmcComponent emcComponent : this.emcComponents) {
            if (!emcComponent.getEmcType().equals((Object)emcType)) continue;
            return true;
        }
        return false;
    }

    public void setValue(float cost) {
        this.value = cost;
    }

    public void setRecoveryPercentage(float recoveryPercentage) {
        this.recoveryPercentage = recoveryPercentage;
    }

    public void addEmcComponent(EmcComponent emcComponent) {
        if (!this.containsEmcType(emcComponent.getEmcType())) {
            this.emcComponents.add(emcComponent);
        }
    }

    public void addEmcComponent(EmcType emcType, float percentage) {
        this.addEmcComponent(new EmcComponent(emcType, percentage));
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmcValue)) {
            return false;
        }
        EmcValue emcValue = (EmcValue)object;
        if (this.value == emcValue.value && this.recoveryPercentage == emcValue.recoveryPercentage) {
            return this.emcComponents.equals(emcValue.getComponents());
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("EMC Value: %s, Recovery Percentage: %s, ", Float.valueOf(this.value), Float.valueOf(this.recoveryPercentage * 100.0f)));
        for (EmcComponent emcComponent : this.emcComponents) {
            stringBuilder.append(String.format("%s ", emcComponent));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 37 * hashCode + Float.floatToIntBits(this.value);
        hashCode = 37 * hashCode + Float.floatToIntBits(this.recoveryPercentage);
        hashCode = 37 * hashCode + this.emcComponents.hashCode();
        return hashCode;
    }
}

