/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.core.util.NBTHelper;
import com.pahimar.ee3.core.util.TransmutationHelper;
import com.pahimar.ee3.item.IChargeable;
import com.pahimar.ee3.item.IKeyBound;
import com.pahimar.ee3.item.ITransmutationStone;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.network.PacketTypeHandler;
import com.pahimar.ee3.network.packet.PacketSoundEvent;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemPhilosophersStone
extends ItemEE
implements ITransmutationStone,
IChargeable,
IKeyBound {
    private int maxChargeLevel;

    public ItemPhilosophersStone(int id) {
        super(id);
        this.func_77655_b("stonePhilosophers");
        this.func_77637_a(EquivalentExchange3.tabsEE3);
        this.func_77656_e(ConfigurationSettings.PHILOSOPHERS_STONE_MAX_DURABILITY - 1);
        this.maxChargeLevel = 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "itemCraftingGuiOpen") || NBTHelper.hasTag(itemStack, "itemTransmutationGuiOpen");
    }

    public String func_77628_j(ItemStack itemStack) {
        return EnumChatFormatting.YELLOW + super.func_77628_j(itemStack);
    }

    public boolean func_77630_h(ItemStack itemStack) {
        return false;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack getContainerItemStack(ItemStack itemStack) {
        ItemStack copiedStack = itemStack.func_77946_l();
        copiedStack.func_77964_b(copiedStack.func_77960_j() + 1);
        return copiedStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int sideHit, float hitVecX, float hitVecY, float hitVecZ) {
        if (world.field_72995_K) {
            this.transmuteBlock(itemStack, entityPlayer, world, x, y, z, sideHit);
        }
        return true;
    }

    @Override
    public void openPortableCraftingGUI(EntityPlayer thePlayer, ItemStack itemStack) {
        NBTHelper.setBoolean(itemStack, "itemCraftingGuiOpen", true);
        thePlayer.openGui((Object)EquivalentExchange3.instance, 0, thePlayer.field_70170_p, (int)thePlayer.field_70165_t, (int)thePlayer.field_70163_u, (int)thePlayer.field_70161_v);
    }

    @Override
    public void openPortableTransmutationGUI(EntityPlayer thePlayer, ItemStack itemStack) {
        NBTHelper.setBoolean(itemStack, "itemTransmutationGuiOpen", true);
        thePlayer.openGui((Object)EquivalentExchange3.instance, 1, thePlayer.field_70170_p, (int)thePlayer.field_70165_t, (int)thePlayer.field_70163_u, (int)thePlayer.field_70161_v);
    }

    @Override
    public void transmuteBlock(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int sideHit) {
        EquivalentExchange3.proxy.transmuteBlock(itemStack, player, world, x, y, z, sideHit);
    }

    @Override
    public short getCharge(ItemStack stack) {
        return NBTHelper.getShort(stack, "itemChargeLevel");
    }

    @Override
    public void setCharge(ItemStack stack, short charge) {
        if (charge <= this.maxChargeLevel) {
            NBTHelper.setShort(stack, "itemChargeLevel", charge);
        }
    }

    @Override
    public void increaseCharge(ItemStack stack) {
        if (NBTHelper.getShort(stack, "itemChargeLevel") < this.maxChargeLevel) {
            NBTHelper.setShort(stack, "itemChargeLevel", (short)(NBTHelper.getShort(stack, "itemChargeLevel") + 1));
        }
    }

    @Override
    public void decreaseCharge(ItemStack stack) {
        if (NBTHelper.getShort(stack, "itemChargeLevel") > 0) {
            NBTHelper.setShort(stack, "itemChargeLevel", (short)(NBTHelper.getShort(stack, "itemChargeLevel") - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer thePlayer, ItemStack itemStack, String keyBinding) {
        if (keyBinding.equals("key.extra")) {
            if (!thePlayer.func_70093_af()) {
                this.openPortableCraftingGUI(thePlayer, itemStack);
            } else {
                this.openPortableTransmutationGUI(thePlayer, itemStack);
            }
        } else if (keyBinding.equals("key.toggle")) {
            if (TransmutationHelper.targetBlockStack != null) {
                TransmutationHelper.targetBlockStack = !thePlayer.func_70093_af() ? TransmutationHelper.getNextBlock(TransmutationHelper.targetBlockStack.field_77993_c, TransmutationHelper.targetBlockStack.func_77960_j()) : TransmutationHelper.getPreviousBlock(TransmutationHelper.targetBlockStack.field_77993_c, TransmutationHelper.targetBlockStack.func_77960_j());
            }
        } else if (keyBinding.equals("key.charge")) {
            if (!thePlayer.func_70093_af()) {
                if (this.getCharge(itemStack) == this.maxChargeLevel) {
                    PacketDispatcher.sendPacketToAllAround((double)thePlayer.field_70165_t, (double)thePlayer.field_70163_u, (double)thePlayer.field_70161_v, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, "mods.ee3.sound.fail", thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v, 1.5f, 1.5f)));
                } else {
                    this.increaseCharge(itemStack);
                    PacketDispatcher.sendPacketToAllAround((double)thePlayer.field_70165_t, (double)thePlayer.field_70163_u, (double)thePlayer.field_70161_v, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, "mods.ee3.sound.chargeUp", thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v, 0.5f, 0.5f + 0.5f * ((float)this.getCharge(itemStack) * 1.0f / (float)this.maxChargeLevel))));
                }
            } else if (this.getCharge(itemStack) == 0) {
                PacketDispatcher.sendPacketToAllAround((double)thePlayer.field_70165_t, (double)thePlayer.field_70163_u, (double)thePlayer.field_70161_v, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, "mods.ee3.sound.fail", thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v, 1.5f, 1.5f)));
            } else {
                this.decreaseCharge(itemStack);
                PacketDispatcher.sendPacketToAllAround((double)thePlayer.field_70165_t, (double)thePlayer.field_70163_u, (double)thePlayer.field_70161_v, (double)64.0, (int)thePlayer.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketTypeHandler.populatePacket(new PacketSoundEvent(thePlayer.field_71092_bJ, "mods.ee3.sound.chargeDown", thePlayer.field_70165_t, thePlayer.field_70163_u, thePlayer.field_70161_v, 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getCharge(itemStack) * 1.0f / (float)this.maxChargeLevel)))));
            }
        }
    }
}

