/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import powercrystals.core.mod.BaseMod;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;
import powercrystals.powerconverters.common.BlockPowerConverterCommon;
import powercrystals.powerconverters.common.ItemBlockPowerConverterCommon;
import powercrystals.powerconverters.common.TileEntityCharger;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.PCGUIHandler;
import powercrystals.powerconverters.net.ClientPacketHandler;
import powercrystals.powerconverters.net.ConnectionHandler;
import powercrystals.powerconverters.net.IPCProxy;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.buildcraft.BlockPowerConverterBuildCraft;
import powercrystals.powerconverters.power.buildcraft.ChargeHandlerThermalExpansion;
import powercrystals.powerconverters.power.buildcraft.ItemBlockPowerConverterBuildCraft;
import powercrystals.powerconverters.power.buildcraft.TileEntityBuildCraftConsumer;
import powercrystals.powerconverters.power.buildcraft.TileEntityBuildCraftProducer;
import powercrystals.powerconverters.power.factorization.BlockPowerConverterFactorization;
import powercrystals.powerconverters.power.factorization.ItemBlockPowerConverterFactorization;
import powercrystals.powerconverters.power.factorization.TileEntityPowerConverterFactorizationConsumer;
import powercrystals.powerconverters.power.factorization.TileEntityPowerConverterFactorizationProducer;
import powercrystals.powerconverters.power.ic2.BlockPowerConverterIndustrialCraft;
import powercrystals.powerconverters.power.ic2.ChargeHandlerIndustrialCraft;
import powercrystals.powerconverters.power.ic2.ItemBlockPowerConverterIndustrialCraft;
import powercrystals.powerconverters.power.ic2.TileEntityIndustrialCraftConsumer;
import powercrystals.powerconverters.power.ic2.TileEntityIndustrialCraftProducer;
import powercrystals.powerconverters.power.railcraft.BlockPowerConverterRailCraft;
import powercrystals.powerconverters.power.railcraft.ItemBlockPowerConverterRailCraft;
import powercrystals.powerconverters.power.railcraft.TileEntityRailCraftConsumer;
import powercrystals.powerconverters.power.railcraft.TileEntityRailCraftProducer;
import powercrystals.powerconverters.power.ue.BlockPowerConverterUniversalElectricity;
import powercrystals.powerconverters.power.ue.ChargeHandlerUniversalElectricity;
import powercrystals.powerconverters.power.ue.ItemBlockPowerConverterUniversalElectricty;
import powercrystals.powerconverters.power.ue.TileEntityUniversalElectricityConsumer;
import powercrystals.powerconverters.power.ue.TileEntityUniversalElectricityProducer;

@Mod(modid="PowerConverters", name="Power Converters", version="1.5.1R2.3.0", dependencies="required-after:PowerCrystalsCore;after:BasicComponents;after:BuildCraft|Energy;after:factorization;after:IC2;after:Railcraft;after:ThermalExpansion")
@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"PowerConverters"}, packetHandler=ClientPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class PowerConverterCore
extends BaseMod {
    public static final String modId = "PowerConverters";
    public static final String modName = "Power Converters";
    public static final String version = "1.5.1R2.3.0";
    @SidedProxy(clientSide="powercrystals.powerconverters.net.ProxyClient", serverSide="powercrystals.powerconverters.net.ProxyServer")
    public static IPCProxy proxy;
    private static final String _texureFolder = "/powercrystals/powerconverters/textures/";
    public static final String guiFolder = "/powercrystals/powerconverters/textures/gui/";
    public static Block converterBlockCommon;
    public static Block converterBlockBuildCraft;
    public static Block converterBlockIndustrialCraft;
    public static Block converterBlockSteam;
    public static Block converterBlockUniversalElectricity;
    public static Block converterBlockFactorization;
    public static PowerConverterCore instance;
    private static Property blockIdCommon;
    private static Property blockIdBuildCraft;
    private static Property blockIdIndustrialCraft;
    private static Property blockIdSteam;
    private static Property blockIdUniversalElectricty;
    private static Property blockIdFactorization;
    public static Property bridgeBufferSize;
    public static Property throttleSteamConsumer;
    public static Property throttleSteamProducer;
    public static Property throttleIC2LVProducer;
    public static Property throttleIC2MVProducer;
    public static Property throttleIC2HVProducer;
    public static Property throttleIC2EVProducer;
    public static PowerSystem powerSystemBuildCraft;
    public static PowerSystem powerSystemIndustrialCraft;
    public static PowerSystem powerSystemSteam;
    public static PowerSystem powerSystemUniversalElectricity;
    public static PowerSystem powerSystemFactorization;
    public static int steamId;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        powerSystemBuildCraft = new PowerSystem("BuildCraft", "BC", 4375, 4375, null, null, "MJ/t");
        powerSystemIndustrialCraft = new PowerSystem("IndustrialCraft", "IC2", 1800, 1800, new String[]{"LV", "MV", "HV", "EV"}, new int[]{32, 128, 512, 2048}, "EU/t");
        powerSystemSteam = new PowerSystem("Steam", "STEAM", 875, 875, null, null, "mB/t");
        powerSystemUniversalElectricity = new PowerSystem("UniversalElectricity", "UE", 10, 10, new String[]{"LV", "MV", "HV", "EV"}, new int[]{60, 120, 240, 480}, "W");
        powerSystemFactorization = new PowerSystem("Factorization", "FZ", 875, 875, null, null, "CG/t");
        PowerSystem.registerPowerSystem(powerSystemBuildCraft);
        PowerSystem.registerPowerSystem(powerSystemIndustrialCraft);
        PowerSystem.registerPowerSystem(powerSystemSteam);
        PowerSystem.registerPowerSystem(powerSystemUniversalElectricity);
        PowerSystem.registerPowerSystem(powerSystemFactorization);
        this.setConfigFolderBase(evt.getModConfigurationDirectory());
        Configuration c = new Configuration(this.getCommonConfig());
        PowerConverterCore.loadConfig(c);
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) throws Exception {
        Object fzRegistry;
        instance = this;
        converterBlockCommon = new BlockPowerConverterCommon(blockIdCommon.getInt());
        GameRegistry.registerBlock((Block)converterBlockCommon, ItemBlockPowerConverterCommon.class, (String)converterBlockCommon.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityEnergyBridge.class, (String)"powerConverterEnergyBridge");
        GameRegistry.registerTileEntity(TileEntityCharger.class, (String)"powerConverterUniversalCharger");
        LanguageRegistry.addName((Object)new ItemStack(converterBlockCommon, 1, 0), (String)"Energy Bridge");
        LanguageRegistry.addName((Object)new ItemStack(converterBlockCommon, 1, 2), (String)"Universal Charger");
        GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockCommon, 1, 0), (Object[])new Object[]{"GRG", "LDL", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('L'), Block.field_71946_M, Character.valueOf('D'), Item.field_77702_n});
        GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockCommon, 1, 2), (Object[])new Object[]{"GRG", "ICI", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Block.field_72077_au});
        if (Loader.isModLoaded((String)"BuildCraft|Energy") || Loader.isModLoaded((String)"ThermalExpansion")) {
            converterBlockBuildCraft = new BlockPowerConverterBuildCraft(blockIdBuildCraft.getInt());
            GameRegistry.registerBlock((Block)converterBlockBuildCraft, ItemBlockPowerConverterBuildCraft.class, (String)converterBlockBuildCraft.func_71917_a());
            GameRegistry.registerTileEntity(TileEntityBuildCraftConsumer.class, (String)"powerConverterBCConsumer");
            GameRegistry.registerTileEntity(TileEntityBuildCraftProducer.class, (String)"powerConverterBCProducer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockBuildCraft, 1, 0), (String)"BC Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockBuildCraft, 1, 1), (String)"BC Producer");
            if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), new ItemStack((Block)Class.forName("buildcraft.BuildCraftEnergy").getField("engineBlock").get(null), 1, 1)});
            }
            if (Loader.isModLoaded((String)"ThermalExpansion")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), new ItemStack((Block)Class.forName("thermalexpansion.block.TEBlocks").getField("blockEngine").get(null), 1, 1)});
                TileEntityCharger.registerChargeHandler(new ChargeHandlerThermalExpansion());
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockBuildCraft, 1, 1), (Object[])new Object[]{new ItemStack(converterBlockBuildCraft, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockBuildCraft, 1, 0), (Object[])new Object[]{new ItemStack(converterBlockBuildCraft, 1, 1)});
        }
        if (Loader.isModLoaded((String)"IC2")) {
            converterBlockIndustrialCraft = new BlockPowerConverterIndustrialCraft(blockIdIndustrialCraft.getInt());
            GameRegistry.registerBlock((Block)converterBlockIndustrialCraft, ItemBlockPowerConverterIndustrialCraft.class, (String)converterBlockIndustrialCraft.func_71917_a());
            GameRegistry.registerTileEntity(TileEntityIndustrialCraftConsumer.class, (String)"powerConverterIC2Consumer");
            GameRegistry.registerTileEntity(TileEntityIndustrialCraftProducer.class, (String)"powerConverterIC2Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 0), (String)"IC2 LV Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 1), (String)"IC2 LV Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 2), (String)"IC2 MV Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 3), (String)"IC2 MV Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 4), (String)"IC2 HV Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 5), (String)"IC2 HV Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 6), (String)"IC2 EV Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockIndustrialCraft, 1, 7), (String)"IC2 EV Producer");
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 0), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('T'), (ItemStack)Class.forName("ic2.core.Ic2Items").getField("lvTransformer").get(null)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 2), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('T'), (ItemStack)Class.forName("ic2.core.Ic2Items").getField("mvTransformer").get(null)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 4), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('T'), (ItemStack)Class.forName("ic2.core.Ic2Items").getField("hvTransformer").get(null)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 6), (Object[])new Object[]{"G G", " T ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('T'), (ItemStack)Class.forName("ic2.core.Ic2Items").getField("mfsUnit").get(null)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 1), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 0), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 1)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 3), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 2)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 2), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 3)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 5), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 4)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 4), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 5)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 7), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 6)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockIndustrialCraft, 1, 6), (Object[])new Object[]{new ItemStack(converterBlockIndustrialCraft, 1, 7)});
            TileEntityCharger.registerChargeHandler(new ChargeHandlerIndustrialCraft());
        }
        if (Loader.isModLoaded((String)"Railcraft") || Loader.isModLoaded((String)"factorization")) {
            converterBlockSteam = new BlockPowerConverterRailCraft(blockIdSteam.getInt());
            GameRegistry.registerBlock((Block)converterBlockSteam, ItemBlockPowerConverterRailCraft.class, (String)converterBlockSteam.func_71917_a());
            GameRegistry.registerTileEntity(TileEntityRailCraftConsumer.class, (String)"powerConverterSteamConsumer");
            GameRegistry.registerTileEntity(TileEntityRailCraftProducer.class, (String)"powerConverterSteamProducer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockSteam, 1, 0), (String)"Steam Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockSteam, 1, 1), (String)"Steam Producer");
            if (Loader.isModLoaded((String)"Railcraft")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockSteam, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), new ItemStack((Block)Class.forName("mods.railcraft.common.blocks.RailcraftBlocks").getMethod("getBlockMachineBeta", new Class[0]).invoke(null, new Object[0]), 1, 8)});
            } else {
                fzRegistry = Class.forName("factorization.common.Core").getField("registry").get(null);
                GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockSteam, 1, 0), (Object[])new Object[]{"G G", " E ", "G G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), (ItemStack)Class.forName("factorization.common.Registry").getField("steamturbine_item").get(fzRegistry)});
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockSteam, 1, 1), (Object[])new Object[]{new ItemStack(converterBlockSteam, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockSteam, 1, 0), (Object[])new Object[]{new ItemStack(converterBlockSteam, 1, 1)});
        }
        if (Loader.isModLoaded((String)"BasicComponents") || Loader.isModLoaded((String)"mmmPowerSuits")) {
            TileEntityCharger.registerChargeHandler(new ChargeHandlerUniversalElectricity());
        }
        if (Loader.isModLoaded((String)"BasicComponents")) {
            converterBlockUniversalElectricity = new BlockPowerConverterUniversalElectricity(blockIdUniversalElectricty.getInt());
            GameRegistry.registerBlock((Block)converterBlockUniversalElectricity, ItemBlockPowerConverterUniversalElectricty.class, (String)converterBlockUniversalElectricity.func_71917_a());
            GameRegistry.registerTileEntity(TileEntityUniversalElectricityConsumer.class, (String)"powerConverterUEConsumer");
            GameRegistry.registerTileEntity(TileEntityUniversalElectricityProducer.class, (String)"powerConverterUEProducer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 0), (String)"UE 60V Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 1), (String)"UE 60V Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 2), (String)"UE 120V Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 3), (String)"UE 120V Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 4), (String)"UE 240V Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 5), (String)"UE 240V Producer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 6), (String)"UE 480V Consumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockUniversalElectricity, 1, 7), (String)"UE 480V Producer");
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 0), (Object[])new Object[]{"I I", "   ", "IBI", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('B'), new ItemStack((Block)Class.forName("universalelectricity.components.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 2), (Object[])new Object[]{"I I", " B ", "I I", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('B'), new ItemStack((Block)Class.forName("universalelectricity.components.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 4), (Object[])new Object[]{"IBI", "   ", "I I", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('B'), new ItemStack((Block)Class.forName("universalelectricity.components.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 6), (Object[])new Object[]{"IBI", "I I", "I I", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('B'), new ItemStack((Block)Class.forName("universalelectricity.components.common.BasicComponents").getField("blockMachine").get(null), 1, 4)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 1), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 0), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 1)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 3), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 2)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 2), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 3)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 5), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 4)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 4), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 5)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 7), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 6)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockUniversalElectricity, 1, 6), (Object[])new Object[]{new ItemStack(converterBlockUniversalElectricity, 1, 7)});
        }
        if (Loader.isModLoaded((String)"factorization")) {
            converterBlockFactorization = new BlockPowerConverterFactorization(blockIdFactorization.getInt());
            GameRegistry.registerBlock((Block)converterBlockFactorization, ItemBlockPowerConverterFactorization.class, (String)converterBlockFactorization.func_71917_a());
            GameRegistry.registerTileEntity(TileEntityPowerConverterFactorizationConsumer.class, (String)"powerConverterFZConsumer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockFactorization, 1, 0), (String)"Factorization Consumer");
            GameRegistry.registerTileEntity(TileEntityPowerConverterFactorizationProducer.class, (String)"powerConverterFZProducer");
            LanguageRegistry.addName((Object)new ItemStack(converterBlockFactorization, 1, 1), (String)"Factorization Producer");
            fzRegistry = Class.forName("factorization.common.Core").getField("registry").get(null);
            GameRegistry.addRecipe((ItemStack)new ItemStack(converterBlockFactorization, 1, 0), (Object[])new Object[]{"I I", " B ", "I I", Character.valueOf('I'), Item.field_77717_p, Character.valueOf('B'), (ItemStack)Class.forName("factorization.common.Registry").getField("solarboiler_item").get(fzRegistry)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockFactorization, 1, 1), (Object[])new Object[]{new ItemStack(converterBlockFactorization, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(converterBlockFactorization, 1, 0), (Object[])new Object[]{new ItemStack(converterBlockFactorization, 1, 1)});
        }
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new PCGUIHandler());
        if (LiquidDictionary.getLiquids().get("Steam") != null) {
            steamId = ((LiquidStack)LiquidDictionary.getLiquids().get((Object)"Steam")).itemID;
        }
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.load();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager((IUpdateableMod)this), (Side)Side.CLIENT);
    }

    @ForgeSubscribe
    public void forgeEvent(LiquidDictionary.LiquidRegisterEvent e) {
        if (e.Name.equals("Steam")) {
            steamId = e.Liquid.itemID;
        } else if (e.Name.equals("steam") && steamId <= 0) {
            steamId = e.Liquid.itemID;
        }
    }

    private static void loadConfig(Configuration c) {
        blockIdCommon = c.getBlock("ID.BlockCommon", 2850);
        blockIdBuildCraft = c.getBlock("ID.BlockBuildcraft", 2851);
        blockIdIndustrialCraft = c.getBlock("ID.BlockIndustrialCraft", 2852);
        blockIdSteam = c.getBlock("ID.BlockSteam", 2853);
        blockIdUniversalElectricty = c.getBlock("ID.BlockUniversalElectricty", 2854);
        blockIdFactorization = c.getBlock("ID.BlockFactorization", 2855);
        bridgeBufferSize = c.get("general", "BridgeBufferSize", 160000000);
        throttleSteamConsumer = c.get("Throttles", "Steam.Consumer", 1000);
        PowerConverterCore.throttleSteamConsumer.comment = "mB/t";
        throttleSteamProducer = c.get("Throttles", "Steam.Producer", 1000);
        PowerConverterCore.throttleSteamProducer.comment = "mB/t";
        throttleIC2LVProducer = c.get("Throttles", "IC2.Consumer.LV", 1);
        PowerConverterCore.throttleIC2LVProducer.comment = "Packets/t";
        throttleIC2MVProducer = c.get("Throttles", "IC2.Consumer.MV", 1);
        PowerConverterCore.throttleIC2MVProducer.comment = "Packets/t";
        throttleIC2HVProducer = c.get("Throttles", "IC2.Consumer.HV", 1);
        PowerConverterCore.throttleIC2HVProducer.comment = "Packets/t";
        throttleIC2EVProducer = c.get("Throttles", "IC2.Consumer.EV", 1);
        PowerConverterCore.throttleIC2EVProducer.comment = "Packets/t";
        PowerSystem.loadConfig(c);
        c.save();
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        steamId = -1;
    }
}

