/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.inventory.IInventoryManager;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.common.IChargeHandler;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityCharger
extends TileEntityEnergyProducer {
    private static List _chargeHandlers = new ArrayList();
    private EntityPlayer _player;

    public static void registerChargeHandler(IChargeHandler handler) {
        _chargeHandlers.add(handler);
    }

    public TileEntityCharger() {
        super(PowerConverterCore.powerSystemIndustrialCraft, 0, IInventory.class);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this._player != null && this._player.func_70011_f((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) > 2.0) {
            this.setPlayer(null);
        }
    }

    @Override
    public int produceEnergy(int energy) {
        if (energy == 0) {
            return 0;
        }
        int energyRemaining = energy;
        if (this._player != null) {
            energyRemaining = this.chargeInventory((IInventory)this._player.field_71071_by, ForgeDirection.UNKNOWN, energyRemaining);
        }
        for (Map.Entry inv : this.getTiles().entrySet()) {
            energyRemaining = this.chargeInventory((IInventory)inv.getValue(), (ForgeDirection)inv.getKey(), energyRemaining);
        }
        return energyRemaining;
    }

    private int chargeInventory(IInventory inventory, ForgeDirection toSide, int energy) {
        PowerSystem nextPowerSystem = this.getPowerSystem();
        int energyRemaining = energy;
        IInventoryManager inv = InventoryManager.create((IInventory)inventory, (ForgeDirection)toSide.getOpposite());
        for (Map.Entry contents : inv.getContents().entrySet()) {
            for (IChargeHandler chargeHandler : _chargeHandlers) {
                ItemStack s = (ItemStack)contents.getValue();
                if (s == null || !chargeHandler.canHandle(s) || (energyRemaining = chargeHandler.charge(s, energyRemaining)) >= energy) continue;
                nextPowerSystem = chargeHandler.getPowerSystem();
                energy = energyRemaining;
            }
        }
        this._powerSystem = nextPowerSystem;
        return energyRemaining;
    }

    public void setPlayer(EntityPlayer player) {
        if (this.field_70331_k.field_72995_K && this._player != player) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this._player = player;
        }
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() || this._player != null;
    }

    @Override
    public boolean isSideConnected(int side) {
        if (side == 1 && this._player != null) {
            return true;
        }
        return super.isSideConnected(side);
    }

    @Override
    public boolean isSideConnectedClient(int side) {
        if (side == 1 && this._player != null) {
            return true;
        }
        return super.isSideConnectedClient(side);
    }
}

