/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.factorization;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import powercrystals.powerconverters.PowerConverterCore;
import powercrystals.powerconverters.power.TileEntityEnergyProducer;

public class TileEntityPowerConverterFactorizationProducer
extends TileEntityEnergyProducer
implements IChargeConductor {
    private Charge _charge = new Charge((IChargeConductor)this);
    private static final int _maxCG = 1000;

    public TileEntityPowerConverterFactorizationProducer() {
        super(PowerConverterCore.powerSystemFactorization, 0, IChargeConductor.class);
    }

    @Override
    public int produceEnergy(int energy) {
        int CG = energy / PowerConverterCore.powerSystemFactorization.getInternalEnergyPerOutput();
        for (Map.Entry output : this.getTiles().entrySet()) {
            IChargeConductor o = (IChargeConductor)output.getValue();
            if (o == null || o.getCharge().getValue() >= 1000) continue;
            int store = Math.min(1000 - o.getCharge().getValue(), CG);
            o.getCharge().addValue(store);
            if ((CG -= store) > 0) continue;
            break;
        }
        return CG * PowerConverterCore.powerSystemFactorization.getInternalEnergyPerOutput();
    }

    public Charge getCharge() {
        return this._charge;
    }

    public String getInfo() {
        return null;
    }

    public Coord getCoord() {
        return new Coord((TileEntity)this);
    }
}

