/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLeafPile
extends Block {
    private Icon texture;

    private static boolean canThisPlantGrowOnThisBlockID(int blockId) {
        return blockId == Block.field_71980_u.field_71990_ca || blockId == Block.field_71979_v.field_71990_ca;
    }

    public BlockLeafPile(int id, int index, Material material) {
        super(id, material);
        float f = 0.5f;
        float f1 = 0.015625f;
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.texture = iconRegister.func_94245_a("ExtrabiomesXL:leafpile");
    }

    public Icon func_71858_a(int side, int metadata) {
        return this.texture;
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return BlockLeafPile.canThisPlantGrowOnThisBlockID(world.func_72798_a(x, y - 1, z));
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return super.func_71930_b(world, x, y, z) && BlockLeafPile.canThisPlantGrowOnThisBlockID(world.func_72798_a(x, y - 1, z));
    }

    private void checkFlowerChange(World world, int x, int y, int z) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94575_c(x, y, z, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess iBlockAccess, int x, int y, int z) {
        return iBlockAccess.func_72807_a(x, z).func_76726_l();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71933_m() {
        return ColorizerFoliage.func_77468_c();
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71889_f_(int metadata) {
        return this.func_71933_m();
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int neigborId) {
        super.func_71863_a(world, x, y, z, neigborId);
        this.checkFlowerChange(world, x, y, z);
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        this.checkFlowerChange(world, x, y, z);
    }
}

