/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAcacia
extends WorldGenerator {
    public WorldGenAcacia(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int y1;
        int height = rand.nextInt(4) + 6;
        boolean canGrow = true;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y12 = y; y12 <= y + 1 + height; ++y12) {
            int clearance = 1;
            if (y12 == y) {
                clearance = 0;
            }
            if (y12 >= y + 1 + height - 2) {
                clearance = 2;
            }
            for (int x1 = x - clearance; x1 <= x + clearance && canGrow; ++x1) {
                for (int z1 = z - clearance; z1 <= z + clearance && canGrow; ++z1) {
                    if (y12 >= 0 && y12 < 256) {
                        int id = world.func_72798_a(x1, y12, z1);
                        if (Block.field_71973_m[id] == null || Block.field_71973_m[id].isLeaves(world, x1, y12, z1) || id == Block.field_71980_u.field_71990_ca || id == Block.field_71979_v.field_71990_ca || Block.field_71973_m[id].isWood(world, x1, y12, z1)) continue;
                        canGrow = false;
                        continue;
                    }
                    canGrow = false;
                }
            }
        }
        if (!canGrow) {
            return false;
        }
        if (!TreeSoilRegistry.isValidSoil(world.func_72798_a(x, y - 1, z)) || y >= 256 - height - 1) {
            return false;
        }
        world.func_94575_c(x, y - 1, z, Block.field_71979_v.field_71990_ca);
        int canopyHeight = 3;
        boolean minCanopyRadius = false;
        for (y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int distanceFromTop = y1 - (y + height);
            int canopyRadius = 1 - distanceFromTop;
            for (int x1 = x - canopyRadius; x1 <= x + canopyRadius; ++x1) {
                int xOnRadius = x1 - x;
                for (int z1 = z - canopyRadius; z1 <= z + canopyRadius; ++z1) {
                    int zOnRadius = z1 - z;
                    Block block = Block.field_71973_m[world.func_72798_a(x1, y1, z1)];
                    if (Math.abs(xOnRadius) == canopyRadius && Math.abs(zOnRadius) == canopyRadius && (rand.nextInt(2) == 0 || distanceFromTop == 0) || block != null && !block.canBeReplacedByLeaves(world, x1, y1, z1)) continue;
                    this.func_76485_a(world, x1, y1, z1, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                }
            }
        }
        for (y1 = 0; y1 < height; ++y1) {
            int id = world.func_72798_a(x, y + y1, z);
            if (Block.field_71973_m[id] != null && !Block.field_71973_m[id].isLeaves(world, x, y + y1, z)) continue;
            this.func_76485_a(world, x, y + y1, z, TreeBlock.TRUNK.getID(), TreeBlock.TRUNK.getMetadata());
        }
        return true;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Block.field_71952_K)),
        TRUNK(new ItemStack(Block.field_71951_J));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_ACACIA.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_ACACIA.get();
            }
            if (Element.LOG_ACACIA.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_ACACIA.get();
            }
            loadedCustomBlocks = true;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private TreeBlock() {
            void stack;
            this.stack = stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.field_77993_c;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

