/*
 * Decompiled with CFR 0.152.
 */
package eplus.network.packets;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import eplus.lib.ConfigurationSettings;
import eplus.network.packets.BasePacket;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class EnchantmentAllowedPacket
extends BasePacket {
    private HashMap<String, Boolean> enchantments;

    public EnchantmentAllowedPacket() {
    }

    public EnchantmentAllowedPacket(HashMap<String, Boolean> enchantments) {
        this.enchantments = enchantments;
    }

    @Override
    public void execute(EntityPlayer player, Side side) {
        if (side == Side.CLIENT) {
            ConfigurationSettings.enchantments = this.enchantments;
        }
    }

    @Override
    public void read(ByteArrayDataInput input) {
        HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            temp.put(input.readUTF(), input.readBoolean());
        }
        this.enchantments = temp;
    }

    @Override
    protected void write(ByteArrayDataOutput output) {
        int size = this.enchantments.keySet().size();
        output.writeInt(size);
        for (String enchant : this.enchantments.keySet()) {
            output.writeUTF(enchant);
            output.writeBoolean(this.enchantments.get(enchant).booleanValue());
        }
    }
}

