/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import powercrystals.core.gui.controls.Button;

public abstract class ButtonOption
extends Button {
    private Map _values = new HashMap();
    private int _currentValue = 0;
    private int _maxValue;

    public ButtonOption(GuiContainer containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height, "");
    }

    public void setValue(int value, String label) {
        this._values.put(value, label);
        if (value > this._maxValue) {
            this._maxValue = value;
        }
    }

    @Override
    public void onClick() {
        int nextValue = this._currentValue + 1;
        if (nextValue > this._maxValue) {
            nextValue = 0;
        }
        while (this._values.get(nextValue) == null) {
            ++nextValue;
        }
        this.setSelectedIndex(nextValue);
    }

    @Override
    public void onRightClick() {
        int nextValue = this._currentValue - 1;
        while (this._values.get(nextValue) == null) {
            if (--nextValue >= 0) continue;
            nextValue = this._maxValue;
        }
        this.setSelectedIndex(nextValue);
    }

    public int getSelectedIndex() {
        return this._currentValue;
    }

    public void setSelectedIndex(int index) {
        this._currentValue = index;
        this.setText((String)this._values.get(this._currentValue));
        this.onValueChanged(this._currentValue, (String)this._values.get(this._currentValue));
    }

    public String getValue() {
        return (String)this._values.get(this._currentValue);
    }

    public abstract void onValueChanged(int var1, String var2);
}

