/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import powercrystals.core.block.BlockFluidClassic;
import powercrystals.core.block.BlockFluidRoot;

public class RenderBlockFluidClassic
implements ISimpleBlockRenderingHandler {
    private int _renderId;

    public RenderBlockFluidClassic(int renderId) {
        this._renderId = renderId;
    }

    public static void initialize() {
    }

    public float getFluidHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                return flow[i];
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        return total / (float)count;
    }

    public float getFluidHeightForRender(IBlockAccess world, int x, int y, int z, BlockFluidClassic block) {
        if (world.func_72798_a(x, y, z) == block.field_71990_ca) {
            if (world.func_72798_a(x, y - block.densityDir, z) == block.field_71990_ca) {
                return 1.0f;
            }
            if (world.func_72805_g(x, y, z) == block.quantaPerBlock - 1) {
                return 0.875f;
            }
        }
        return !world.func_72803_f(x, y, z).func_76220_a() && world.func_72798_a(x, y - block.densityDir, z) == block.field_71990_ca ? 1.0f : block.getQuantaPercentage(world, x, y, z) * 0.875f;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        float f7;
        float f8;
        boolean rises;
        double d5;
        double d4;
        double d3;
        double d2;
        if (!(block instanceof BlockFluidClassic)) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        int l = block.func_71920_b(world, x, y, z);
        float red = (float)(l >> 16 & 0xFF) / 255.0f;
        float green = (float)(l >> 8 & 0xFF) / 255.0f;
        float blue = (float)(l & 0xFF) / 255.0f;
        BlockFluidClassic theFluid = (BlockFluidClassic)block;
        int bMeta = world.func_72805_g(x, y, z);
        boolean renderTop = world.func_72798_a(x, y - theFluid.densityDir, z) != theFluid.field_71990_ca;
        boolean renderBottom = block.func_71877_c(world, x, y + theFluid.densityDir, z, 0) && world.func_72798_a(x, y + theFluid.densityDir, z) != theFluid.field_71990_ca;
        boolean[] renderSides = new boolean[]{block.func_71877_c(world, x, y, z - 1, 2), block.func_71877_c(world, x, y, z + 1, 3), block.func_71877_c(world, x - 1, y, z, 4), block.func_71877_c(world, x + 1, y, z, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float flow11 = this.getFluidHeightForRender(world, x, y, z, theFluid);
        if (flow11 != 1.0f) {
            float flow00 = this.getFluidHeightForRender(world, x - 1, y, z - 1, theFluid);
            float flow01 = this.getFluidHeightForRender(world, x - 1, y, z, theFluid);
            float flow02 = this.getFluidHeightForRender(world, x - 1, y, z + 1, theFluid);
            float flow10 = this.getFluidHeightForRender(world, x, y, z - 1, theFluid);
            float flow12 = this.getFluidHeightForRender(world, x, y, z + 1, theFluid);
            float flow20 = this.getFluidHeightForRender(world, x + 1, y, z - 1, theFluid);
            float flow21 = this.getFluidHeightForRender(world, x + 1, y, z, theFluid);
            float flow22 = this.getFluidHeightForRender(world, x + 1, y, z + 1, theFluid);
            d2 = this.getFluidHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            d3 = this.getFluidHeightAverage(new float[]{flow01, flow02, flow11, flow12});
            d4 = this.getFluidHeightAverage(new float[]{flow11, flow12, flow21, flow22});
            d5 = this.getFluidHeightAverage(new float[]{flow10, flow11, flow20, flow21});
        } else {
            d2 = flow11;
            d3 = flow11;
            d4 = flow11;
            d5 = flow11;
        }
        double d6 = 0.001f;
        boolean bl = rises = theFluid.densityDir == 1;
        if (renderer.field_78661_f || renderTop) {
            double d13;
            double d9;
            double d14;
            double d10;
            double d11;
            double d7;
            double d12;
            double d8;
            rendered = true;
            Icon icon = block.func_71858_a(1, bMeta);
            float flowDir = (float)BlockFluidRoot.getFlowDirection(world, x, y, z);
            if (flowDir > -999.0f) {
                icon = block.func_71858_a(2, bMeta);
            }
            d2 -= d6;
            d3 -= d6;
            d4 -= d6;
            d5 -= d6;
            if (flowDir < -999.0f) {
                d8 = icon.func_94214_a(0.0);
                d12 = icon.func_94207_b(0.0);
                d7 = d8;
                d11 = icon.func_94207_b(16.0);
                d10 = icon.func_94214_a(16.0);
                d14 = d11;
                d9 = d10;
                d13 = d12;
            } else {
                f8 = MathHelper.func_76126_a((float)flowDir) * 0.25f;
                f7 = MathHelper.func_76134_b((float)flowDir) * 0.25f;
                d8 = icon.func_94214_a((double)(8.0f + (-f7 - f8) * 16.0f));
                d12 = icon.func_94207_b((double)(8.0f + (-f7 + f8) * 16.0f));
                d7 = icon.func_94214_a((double)(8.0f + (-f7 + f8) * 16.0f));
                d11 = icon.func_94207_b((double)(8.0f + (f7 + f8) * 16.0f));
                d10 = icon.func_94214_a((double)(8.0f + (f7 + f8) * 16.0f));
                d14 = icon.func_94207_b((double)(8.0f + (f7 - f8) * 16.0f));
                d9 = icon.func_94214_a((double)(8.0f + (f7 - f8) * 16.0f));
                d13 = icon.func_94207_b((double)(8.0f + (-f7 - f8) * 16.0f));
            }
            tessellator.func_78380_c(block.func_71874_e(world, x, y, z));
            f8 = 1.0f;
            tessellator.func_78386_a(f4 * f8 * red, f4 * f8 * green, f4 * f8 * blue);
            if (!rises) {
                tessellator.func_78374_a((double)(x + 0), (double)y + d2, (double)(z + 0), d8, d12);
                tessellator.func_78374_a((double)(x + 0), (double)y + d3, (double)(z + 1), d7, d11);
                tessellator.func_78374_a((double)(x + 1), (double)y + d4, (double)(z + 1), d10, d14);
                tessellator.func_78374_a((double)(x + 1), (double)y + d5, (double)(z + 0), d9, d13);
            } else {
                tessellator.func_78374_a((double)(x + 1), (double)(y + 1) - d5, (double)(z + 0), d9, d13);
                tessellator.func_78374_a((double)(x + 1), (double)(y + 1) - d4, (double)(z + 1), d10, d14);
                tessellator.func_78374_a((double)(x + 0), (double)(y + 1) - d3, (double)(z + 1), d7, d11);
                tessellator.func_78374_a((double)(x + 0), (double)(y + 1) - d2, (double)(z + 0), d8, d12);
            }
        }
        if (renderer.field_78661_f || renderBottom) {
            rendered = true;
            tessellator.func_78380_c(block.func_71874_e(world, x, y - 1, z));
            float f10 = 1.0f;
            if (!rises) {
                tessellator.func_78386_a(f3 * f10, f3 * f10, f3 * f10);
                renderer.func_78613_a(block, (double)x, (double)y + d6, (double)z, block.func_71858_a(0, bMeta));
            } else {
                tessellator.func_78386_a(f4 * f10, f4 * f10, f4 * f10);
                renderer.func_78617_b(block, (double)x, (double)y + d6, (double)z, block.func_71858_a(1, bMeta));
            }
        }
        for (int side = 0; side < 4; ++side) {
            double d20;
            double d19;
            double d18;
            double d16;
            double d17;
            double d15;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                }
            }
            Icon icon1 = block.func_71858_a(side + 2, bMeta);
            if (!renderer.field_78661_f && !renderSides[side]) continue;
            rendered = true;
            if (side == 0) {
                d15 = d2;
                d17 = d5;
                d16 = x;
                d18 = x + 1;
                d19 = (double)z + d6;
                d20 = (double)z + d6;
            } else if (side == 1) {
                d15 = d4;
                d17 = d3;
                d16 = x + 1;
                d18 = x;
                d19 = (double)(z + 1) - d6;
                d20 = (double)(z + 1) - d6;
            } else if (side == 2) {
                d15 = d3;
                d17 = d2;
                d16 = (double)x + d6;
                d18 = (double)x + d6;
                d19 = z + 1;
                d20 = z;
            } else {
                d15 = d5;
                d17 = d4;
                d16 = (double)(x + 1) - d6;
                d18 = (double)(x + 1) - d6;
                d19 = z;
                d20 = z + 1;
            }
            float f11 = icon1.func_94214_a(0.0);
            f8 = icon1.func_94214_a(8.0);
            f7 = icon1.func_94207_b((1.0 - d15) * 16.0 * 0.5);
            float f12 = icon1.func_94207_b((1.0 - d17) * 16.0 * 0.5);
            float f13 = icon1.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_71874_e(world, x2, y, z2));
            float f14 = 1.0f;
            f14 = side < 2 ? (f14 *= f5) : (f14 *= f6);
            tessellator.func_78386_a(f4 * f14 * red, f4 * f14 * green, f4 * f14 * blue);
            if (!rises) {
                tessellator.func_78374_a(d16, (double)y + d15, d19, (double)f11, (double)f7);
                tessellator.func_78374_a(d18, (double)y + d17, d20, (double)f8, (double)f12);
                tessellator.func_78374_a(d18, (double)(y + 0), d20, (double)f8, (double)f13);
                tessellator.func_78374_a(d16, (double)(y + 0), d19, (double)f11, (double)f13);
                continue;
            }
            tessellator.func_78374_a(d16, (double)(y + 1 - 0), d19, (double)f11, (double)f13);
            tessellator.func_78374_a(d18, (double)(y + 1 - 0), d20, (double)f8, (double)f13);
            tessellator.func_78374_a(d18, (double)(y + 1) - d17, d20, (double)f8, (double)f12);
            tessellator.func_78374_a(d16, (double)(y + 1) - d15, d19, (double)f11, (double)f7);
        }
        renderer.field_83027_i = 0.0;
        renderer.field_83024_j = 1.0;
        return rendered;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return this._renderId;
    }
}

